/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.DrippyLoadingScreen;
import de.keksuccino.drippyloadingscreen.customization.CustomizationHandler;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.placeholdervalues.PlaceholderTextValueHelper;
import de.keksuccino.konkrete.annotations.OptifineFix;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.resources.WebTextureResourceLocation;
import java.net.HttpURLConnection;
import java.net.URL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;

public class WebTextureCustomizationItem
extends CustomizationItemBase {
    public volatile WebTextureResourceLocation texture;
    public String rawURL = "";
    public volatile boolean ready = false;

    @OptifineFix
    public WebTextureCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action != null && this.action.equalsIgnoreCase("addwebtexture")) {
            this.value = item.getEntryValue("url");
            if (this.value != null) {
                this.rawURL = this.value;
                this.value = PlaceholderTextValueHelper.convertFromRaw(this.value);
                if (this.width <= 0 && this.height <= 0) {
                    this.width = 100;
                }
                new Thread(() -> {
                    try {
                        if (WebTextureCustomizationItem.isValidUrl(this.value)) {
                            long currentTime;
                            this.texture = TextureHandler.getWebResource((String)this.value, (boolean)false);
                            CustomizationHandler.runTaskInMainThread(() -> {
                                try {
                                    this.texture.loadTexture();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            });
                            long startTime = System.currentTimeMillis();
                            while (!(startTime + 15000L < (currentTime = System.currentTimeMillis()) || this.texture.isReady() && this.texture.getResourceLocation() != null)) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (Exception exception) {}
                            }
                            if (this.texture != null && this.texture.getResourceLocation() == null) {
                                this.texture = null;
                                DrippyLoadingScreen.LOGGER.error("[DRIPPY LOADING SCREEN] Web texture loaded but resource location was still null! Unable to use web texture!");
                            }
                            if (this.texture == null || !this.texture.isReady()) {
                                if (this.width <= 0) {
                                    this.width = 100;
                                }
                                if (this.height <= 0) {
                                    this.width = 100;
                                }
                                this.ready = true;
                                return;
                            }
                            int w = this.texture.getWidth();
                            int h = this.texture.getHeight();
                            double ratio = (double)w / (double)h;
                            if (this.width < 0 && this.height >= 0) {
                                this.width = (int)((double)this.height * ratio);
                            }
                            if (this.height < 0 && this.width >= 0) {
                                this.height = (int)((double)this.width / ratio);
                            }
                        }
                        this.ready = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }).start();
            }
        }
    }

    @Override
    public void render(MatrixStack matrix) {
        if (this.shouldRender()) {
            int x = this.getPosX();
            int y = this.getPosY();
            if (this.isTextureReady()) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture.getResourceLocation());
            } else if (WebTextureCustomizationItem.isEditorActive()) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureManager.field_194008_a);
            }
            if (this.isTextureReady() || WebTextureCustomizationItem.isEditorActive()) {
                RenderSystem.enableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
                WebTextureCustomizationItem.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
                RenderSystem.disableBlend();
            }
            if (!this.ready && WebTextureCustomizationItem.isEditorActive()) {
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                int n = this.getPosX() + this.width / 2;
                int n2 = this.getPosY() + this.height / 2;
                Minecraft.func_71410_x().field_71466_p.getClass();
                WebTextureCustomizationItem.func_238471_a_((MatrixStack)matrix, (FontRenderer)fontRenderer, (String)"\u00a7lLOADING TEXTURE..", (int)n, (int)(n2 - 9 / 2), (int)-1);
            }
        }
    }

    public boolean isTextureReady() {
        return this.texture != null && this.texture.isReady() && this.texture.getResourceLocation() != null && this.ready;
    }

    @Override
    public boolean shouldRender() {
        if (this.width < 0 || this.height < 0) {
            return false;
        }
        return super.shouldRender();
    }

    public static boolean isValidUrl(String url) {
        if (url != null && (url.startsWith("http://") || url.startsWith("https://"))) {
            try {
                URL u = new URL(url);
                HttpURLConnection c = (HttpURLConnection)u.openConnection();
                c.addRequestProperty("User-Agent", "Mozilla/4.0");
                c.setRequestMethod("HEAD");
                int r = c.getResponseCode();
                if (r == 200) {
                    return true;
                }
            }
            catch (Exception e1) {
                try {
                    URL u = new URL(url);
                    HttpURLConnection c = (HttpURLConnection)u.openConnection();
                    c.addRequestProperty("User-Agent", "Mozilla/4.0");
                    int r = c.getResponseCode();
                    if (r == 200) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        return false;
    }
}

