/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.items;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import net.minecraft.util.math.MathHelper;

public class ShapeCustomizationItem
extends CustomizationItemBase {
    public Shape shape;
    protected String colorString = "#ffffff";
    protected Color color = Color.WHITE;

    public ShapeCustomizationItem(PropertiesSection item) {
        super(item);
        if (this.action.equals("addshape")) {
            String c;
            String sh = item.getEntryValue("shape");
            if (sh != null) {
                this.value = sh;
                this.shape = Shape.byName(sh);
            }
            if ((c = item.getEntryValue("color")) != null) {
                this.setColor(c);
            }
        }
    }

    @Override
    public void render(MatrixStack matrix) {
        if (this.shouldRender() && this.shape != null) {
            int alpha = this.color.getAlpha();
            int i = MathHelper.func_76123_f((float)(this.opacity * 255.0f));
            if (i < alpha) {
                alpha = i;
            }
            Color c = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), alpha);
            if (this.shape == Shape.RECTANGLE) {
                ShapeCustomizationItem.func_238467_a_((MatrixStack)matrix, (int)this.getPosX(), (int)this.getPosY(), (int)(this.getPosX() + this.width), (int)(this.getPosY() + this.height), (int)c.getRGB());
            }
        }
    }

    public void setColor(String hex) {
        Color c;
        if (hex != null && (c = RenderUtils.getColorFromHexString((String)hex)) != null) {
            this.color = c;
            this.colorString = hex;
            return;
        }
        this.color = Color.WHITE;
        this.colorString = "#ffffff";
    }

    public String getColorString() {
        return this.colorString;
    }

    public Color getColor() {
        return this.color;
    }

    public static enum Shape {
        RECTANGLE("rectangle");

        public String name;

        private Shape(String name) {
            this.name = name;
        }

        public static Shape byName(String name) {
            name = name.toLowerCase();
            for (Shape s : Shape.values()) {
                if (!s.name.equals(name)) continue;
                return s;
            }
            return null;
        }
    }
}

