/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.helper.ui.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.UIBase;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ScrollableScreen
extends Screen {
    protected static final Color ENTRY_BACKGROUND_COLOR = new Color(92, 92, 92);
    protected static final Color SCREEN_BACKGROUND_COLOR = new Color(54, 54, 54);
    protected static final Color HEADER_FOOTER_COLOR = new Color(33, 33, 33);
    protected ScrollArea scrollArea;
    protected Screen parent;
    protected String field_230704_d_;

    public ScrollableScreen(Screen parent, String title) {
        super((ITextComponent)new StringTextComponent(""));
        this.parent = parent;
        this.field_230704_d_ = title;
        this.scrollArea = new ScrollArea(0, 50, 300, 0);
        this.scrollArea.backgroundColor = ENTRY_BACKGROUND_COLOR;
    }

    protected void func_231160_c_() {
        this.scrollArea.x = this.field_230708_k_ / 2 - 150;
        this.scrollArea.height = this.field_230709_l_ - 100;
    }

    public void func_231175_as__() {
        if (!PopupHandler.isPopupActive()) {
            Minecraft.func_71410_x().func_147108_a(this.parent);
        }
    }

    public boolean func_231178_ax__() {
        return true;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableBlend();
        ScrollableScreen.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)SCREEN_BACKGROUND_COLOR.getRGB());
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof ScrollAreaEntryBase)) continue;
            ((ScrollAreaEntryBase)e).isOverlayButtonHovered = this.isOverlayButtonHovered();
        }
        this.scrollArea.render(matrix);
        ScrollableScreen.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)this.field_230708_k_, (int)50, (int)HEADER_FOOTER_COLOR.getRGB());
        ScrollableScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)20, (int)-1);
        ScrollableScreen.func_238467_a_((MatrixStack)matrix, (int)0, (int)(this.field_230709_l_ - 50), (int)this.field_230708_k_, (int)this.field_230709_l_, (int)HEADER_FOOTER_COLOR.getRGB());
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        for (ScrollAreaEntry e : this.scrollArea.getEntries()) {
            if (!(e instanceof ScrollAreaEntryBase) || !((ScrollAreaEntryBase)e).isOverlayButtonHoveredAndOverlapsArea() || ((ScrollAreaEntryBase)e).description == null) continue;
            ScrollableScreen.renderDescription(matrix, ((ScrollAreaEntryBase)e).description, MouseInput.getMouseX(), MouseInput.getMouseY());
            break;
        }
    }

    protected static void renderDescription(MatrixStack matrix, List<String> desc, int mouseX, int mouseY) {
        if (desc != null) {
            int width = 10;
            int height = 10;
            for (String s : desc) {
                int i = Minecraft.func_71410_x().field_71466_p.func_78256_a(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (Minecraft.func_71410_x().field_71462_r.field_230708_k_ < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (Minecraft.func_71410_x().field_71462_r.field_230709_l_ < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre((MatrixStack)matrix, (int)600);
            ScrollableScreen.renderDescriptionBackground(matrix, mouseX, mouseY, width, height);
            RenderSystem.enableBlend();
            int i2 = 5;
            for (String s : desc) {
                ScrollableScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)s, (int)(mouseX + 5), (int)(mouseY + i2), (int)Color.WHITE.getRGB());
                i2 += 10;
            }
            RenderUtils.setZLevelPost((MatrixStack)matrix);
            RenderSystem.disableBlend();
        }
    }

    protected static void renderDescriptionBackground(MatrixStack matrix, int x, int y, int width, int height) {
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)new Color(26, 26, 26, 250).getRGB());
    }

    public boolean isOverlayButtonHovered() {
        return false;
    }

    public static class EmptySpaceEntry
    extends ScrollAreaEntryBase {
        public EmptySpaceEntry(ScrollArea parent, int height) {
            super(parent, null);
            this.renderBody = render -> {};
            this.setHeight(height);
        }
    }

    public static class TextEntry
    extends ScrollAreaEntryBase {
        public String text;
        public boolean bold;

        public TextEntry(ScrollArea parent, String text, boolean bold) {
            super(parent, null);
            this.text = text;
            this.bold = bold;
            this.renderBody = render -> {
                if (this.text != null) {
                    FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                    int xCenter = render.entry.x + render.entry.getWidth() / 2;
                    int yCenter = render.entry.y + render.entry.getHeight() / 2;
                    String s = this.text;
                    if (this.bold) {
                        s = "\u00a7l" + this.text;
                    }
                    MatrixStack matrixStack = render.matrix;
                    font.getClass();
                    TextEntry.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)font, (String)s, (int)xCenter, (int)(yCenter - 9 / 2), (int)-1);
                }
            };
            this.setHeight(18);
        }
    }

    public static class TextFieldEntry
    extends ScrollAreaEntryBase {
        public AdvancedTextField textField;

        public TextFieldEntry(ScrollArea parent, AdvancedTextField textField) {
            super(parent, null);
            this.textField = textField;
            this.textField.func_146203_f(10000);
            this.renderBody = render -> {
                int xCenter = render.entry.x + render.entry.getWidth() / 2;
                this.textField.field_230693_o_ = !this.isOverlayButtonHoveredAndOverlapsArea();
                this.textField.func_230991_b_(200);
                this.textField.setHeight(20);
                this.textField.func_212952_l(xCenter - this.textField.func_230998_h_() / 2);
                this.textField.setY(render.entry.y + 2);
                this.textField.func_230430_a_(render.matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.func_71410_x().func_193989_ak());
            };
            this.setHeight(24);
        }
    }

    public static class ButtonEntry
    extends ScrollAreaEntryBase {
        public AdvancedButton button;

        public ButtonEntry(ScrollArea parent, AdvancedButton button) {
            super(parent, null);
            this.button = button;
            this.renderBody = render -> {
                int xCenter = render.entry.x + render.entry.getWidth() / 2;
                UIBase.colorizeButton(this.button);
                this.button.field_230693_o_ = !this.isOverlayButtonHoveredAndOverlapsArea();
                this.button.func_230991_b_(200);
                this.button.setHeight(20);
                this.button.setX(xCenter - this.button.func_230998_h_() / 2);
                this.button.setY(render.entry.y + 2);
                this.button.func_230430_a_(render.matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.func_71410_x().func_193989_ak());
            };
            this.setHeight(24);
        }
    }

    public static class ScrollAreaEntryBase
    extends ScrollAreaEntry {
        protected int entryHeight = 25;
        protected List<String> description = null;
        protected Consumer<EntryRenderCallback> renderBody;
        protected boolean isOverlayButtonHovered = false;

        public ScrollAreaEntryBase(ScrollArea parent, Consumer<EntryRenderCallback> renderBody) {
            super(parent);
            this.renderBody = renderBody;
        }

        public void renderEntry(MatrixStack matrix) {
            EntryRenderCallback c = new EntryRenderCallback();
            c.entry = this;
            c.matrix = matrix;
            this.renderBody.accept(c);
        }

        public int getHeight() {
            return this.entryHeight;
        }

        public void setHeight(int height) {
            this.entryHeight = height;
        }

        public List<String> getDescription() {
            return this.description;
        }

        public boolean isOverlayButtonHoveredAndOverlapsArea() {
            return this.isOverlayButtonHovered && this.isHovered();
        }

        public void setDescription(List<String> desc) {
            this.description = desc;
        }

        public void setDescription(String[] desc) {
            this.description = Arrays.asList(desc);
        }

        public static class EntryRenderCallback {
            public ScrollAreaEntryBase entry;
            public MatrixStack matrix;
        }
    }
}

