/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.helper.editor.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.drippyloadingscreen.customization.helper.ui.popup.FHPopup;
import de.keksuccino.drippyloadingscreen.customization.items.CustomizationItemBase;
import de.keksuccino.drippyloadingscreen.customization.items.visibilityrequirements.VisibilityRequirementContainer;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedImageButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextProperties;

public class VisibilityRequirementsPopup
extends FHPopup {
    protected CustomizationItemBase parent;
    protected List<Requirement> requirements = new ArrayList<Requirement>();
    protected int currentRequirement = 0;
    protected AdvancedButton doneButton;
    protected AdvancedButton leftButton;
    protected AdvancedButton rightButton;

    public VisibilityRequirementsPopup(CustomizationItemBase parent) {
        super(240);
        this.parent = parent;
        this.doneButton = new AdvancedButton(0, 0, 100, 20, Locals.localize((String)"popup.done", (String[])new String[0]), true, press -> this.setDisplayed(false));
        this.addButton(this.doneButton);
        this.leftButton = new AdvancedImageButton(0, 0, 20, 20, new ResourceLocation("keksuccino", "arrow_left.png"), true, press -> {
            int i = this.currentRequirement - 1;
            if (i >= 0) {
                this.currentRequirement = i;
            }
        });
        this.addButton(this.leftButton);
        this.rightButton = new AdvancedImageButton(0, 0, 20, 20, new ResourceLocation("keksuccino", "arrow_right.png"), true, press -> {
            int i = this.currentRequirement + 1;
            if (i <= this.requirements.size() - 1) {
                this.currentRequirement = i;
            }
        });
        this.addButton(this.rightButton);
        this.initRequirements();
    }

    protected void initRequirements() {
        VisibilityRequirementContainer c = this.parent.visibilityRequirementContainer;
    }

    public void render(MatrixStack matrix, int mouseX, int mouseY, Screen renderIn) {
        super.render(matrix, mouseX, mouseY, renderIn);
        int centerX = renderIn.field_230708_k_ / 2;
        int centerY = renderIn.field_230709_l_ / 2;
        this.doneButton.field_230690_l_ = centerX - this.doneButton.func_230998_h_() / 2;
        this.doneButton.field_230691_m_ = centerY + 50;
        this.leftButton.field_230690_l_ = centerX - this.leftButton.func_230998_h_() - 135;
        this.leftButton.field_230691_m_ = centerY - this.leftButton.func_238483_d_() / 2;
        this.rightButton.field_230690_l_ = centerX + 135;
        this.rightButton.field_230691_m_ = centerY - this.leftButton.func_238483_d_() / 2;
        Requirement r = this.requirements.get(this.currentRequirement);
        if (r != null) {
            r.render(matrix, mouseX, mouseY, renderIn);
        }
        this.renderButtons(matrix, mouseX, mouseY);
    }

    public static class Requirement
    extends AbstractGui {
        protected VisibilityRequirementsPopup parent;
        protected String name;
        protected String desc;
        protected String valueName;
        protected Consumer<Boolean> enabledCallback;
        protected Consumer<Boolean> showIfCallback;
        protected Consumer<String> valueCallback;
        protected CharacterFilter valueFilter;
        protected boolean enabled;
        protected boolean showIf;
        protected String valueString;
        protected List<Runnable> preRenderTasks = new ArrayList<Runnable>();
        protected List<AdvancedButton> buttonList = new ArrayList<AdvancedButton>();
        protected AdvancedButton enableRequirementButton;
        protected AdvancedButton showIfButton;
        protected AdvancedButton showIfNotButton;
        protected AdvancedTextField valueTextField;

        public Requirement(VisibilityRequirementsPopup parent, String name, String desc, @Nullable String valueName, boolean enabled, boolean showIf, Consumer<Boolean> enabledCallback, Consumer<Boolean> showIfCallback, @Nullable Consumer<String> valueCallback, CharacterFilter valueFilter, String valueString) {
            this.parent = parent;
            this.name = name;
            this.desc = desc;
            this.valueName = valueName;
            this.enabledCallback = enabledCallback;
            this.showIfCallback = showIfCallback;
            this.valueCallback = valueCallback;
            this.valueFilter = valueFilter;
            this.enabled = enabled;
            this.showIf = showIf;
            this.valueString = valueString;
            this.init();
        }

        protected void init() {
            String enabledString = Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.enabled", (String[])new String[]{this.name});
            if (!this.enabled) {
                enabledString = Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.disabled", (String[])new String[]{this.name});
            }
            this.enableRequirementButton = new AdvancedButton(0, 0, 150, 20, enabledString, true, press -> {
                if (this.enabled) {
                    this.enabled = false;
                    this.enabledCallback.accept(false);
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.disabled", (String[])new String[]{this.name}));
                } else {
                    this.enabled = true;
                    this.enabledCallback.accept(true);
                    ((AdvancedButton)press).setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.enabled", (String[])new String[]{this.name}));
                }
            });
            ArrayList<String> descLines = new ArrayList<String>();
            descLines.addAll(Arrays.asList(StringUtils.splitLines((String)this.desc, (String)"%n%")));
            descLines.add("");
            descLines.add(Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.toggle.btn.desc", (String[])new String[0]));
            this.enableRequirementButton.setDescription(descLines.toArray(new String[0]));
            this.preRenderTasks.add(() -> this.enableRequirementButton.func_230991_b_(Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)this.enableRequirementButton.func_230458_i_()) + 10));
            this.addButton(this.enableRequirementButton);
            String showIfString = "\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showif", (String[])new String[0]);
            if (!this.showIf) {
                showIfString = Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showif", (String[])new String[0]);
            }
            this.showIfButton = new AdvancedButton(0, 0, 100, 20, showIfString, true, press -> {
                this.showIf = true;
                this.showIfCallback.accept(true);
                ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showif", (String[])new String[0]));
                this.showIfNotButton.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showifnot", (String[])new String[0]));
            });
            this.showIfButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showif.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addButton(this.showIfButton);
            String showIfNotString = "\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showifnot", (String[])new String[0]);
            if (this.showIf) {
                showIfNotString = Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showifnot", (String[])new String[0]);
            }
            this.showIfNotButton = new AdvancedButton(0, 0, 100, 20, showIfNotString, true, press -> {
                this.showIf = false;
                this.showIfCallback.accept(false);
                ((AdvancedButton)press).setMessage("\u00a7a" + Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showifnot", (String[])new String[0]));
                this.showIfButton.setMessage(Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showif", (String[])new String[0]));
            });
            this.showIfNotButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.showifnot.btn.desc", (String[])new String[0]), (String)"%n%"));
            this.addButton(this.showIfNotButton);
            if (this.valueCallback != null && this.valueName != null) {
                this.valueTextField = new AdvancedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 150, 20, true, this.valueFilter);
                this.valueTextField.func_146205_d(true);
                this.valueTextField.func_146195_b(false);
                this.valueTextField.func_146203_f(1000);
                if (this.valueString != null) {
                    this.valueTextField.func_146180_a(this.valueString);
                }
            }
        }

        public void render(MatrixStack matrix, int mouseX, int mouseY, Screen renderIn) {
            for (Runnable r : this.preRenderTasks) {
                r.run();
            }
            float partial = Minecraft.func_71410_x().func_184121_ak();
            int centerX = renderIn.field_230708_k_ / 2;
            int centerY = renderIn.field_230709_l_ / 2;
            Requirement.func_238471_a_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)(Locals.localize((String)"drippyloadingscreen.helper.creator.items.visibilityrequirements.requirement", (String[])new String[0]) + ":"), (int)centerX, (int)(centerY - 83), (int)-1);
            this.enableRequirementButton.field_230690_l_ = centerX - this.enableRequirementButton.func_230998_h_() / 2;
            this.enableRequirementButton.field_230691_m_ = centerY - 70;
            this.showIfButton.field_230690_l_ = centerX - this.showIfButton.func_230998_h_() - 5;
            this.showIfButton.field_230691_m_ = centerY - 40;
            this.showIfNotButton.field_230693_o_ = this.enabled;
            this.showIfNotButton.field_230690_l_ = centerX + 5;
            this.showIfNotButton.field_230691_m_ = centerY - 40;
            this.showIfButton.field_230693_o_ = this.enabled;
            if (this.valueTextField != null) {
                Requirement.func_238471_a_((MatrixStack)matrix, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)(this.valueName + ":"), (int)centerX, (int)(centerY - 10), (int)-1);
                this.valueTextField.field_230690_l_ = centerX - this.valueTextField.func_230998_h_() / 2;
                this.valueTextField.field_230691_m_ = centerY + 3;
                this.valueTextField.func_230430_a_(matrix, mouseX, mouseY, partial);
                this.valueTextField.field_230693_o_ = this.enabled;
                this.valueTextField.func_146184_c(this.enabled);
                this.valueCallback.accept(this.valueTextField.func_146179_b());
                this.valueString = this.valueTextField.func_146179_b();
            }
            this.renderButtons(matrix, mouseX, mouseY, partial);
        }

        protected void renderButtons(MatrixStack matrix, int mouseX, int mouseY, float partial) {
            for (AdvancedButton b : this.buttonList) {
                b.func_230430_a_(matrix, mouseX, mouseY, partial);
            }
        }

        protected void addButton(AdvancedButton b) {
            if (!this.buttonList.contains(b)) {
                this.buttonList.add(b);
                b.ignoreBlockedInput = true;
                this.parent.colorizePopupButton(b);
            }
        }
    }
}

