/*
 * Decompiled with CFR 0.152.
 */
package co.eltrut.differentiate.core.util;

import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class DataUtil {
    public static void registerCompostable(IItemProvider item, float compostableChance) {
        ComposterBlock.field_220299_b.put((Object)item, compostableChance);
    }

    public static void registerFlammable(Block block, int encouragement, int flammability) {
        FireBlock fireBlock = (FireBlock)Blocks.field_150480_ab;
        fireBlock.func_180686_a(block, encouragement, flammability);
    }

    public static void registerCutout(Block block, RenderType type) {
        RenderTypeLookup.setRenderLayer((Block)block, (RenderType)type);
    }

    public static void registerBlockColor(IBlockColor color, Block ... blocks) {
        Minecraft.func_71410_x().func_184125_al().func_186722_a(color, blocks);
    }

    public static void registerItemColor(IItemColor color, IItemProvider ... items) {
        Minecraft.func_71410_x().getItemColors().func_199877_a(color, items);
    }

    public static <T extends TileEntity> void registerTileEntityRenderer(TileEntityType<T> tileEntityType, Function<? super TileEntityRendererDispatcher, ? extends TileEntityRenderer<? super T>> rendererFactory) {
        ClientRegistry.bindTileEntityRenderer(tileEntityType, rendererFactory);
    }

    public static class FlammableChance {
        public static final Pair<Integer, Integer> WOOD = Pair.of((Object)5, (Object)5);
        public static final Pair<Integer, Integer> PLANKS = Pair.of((Object)5, (Object)20);
        public static final Pair<Integer, Integer> BOOKSHELF = Pair.of((Object)30, (Object)20);
        public static final Pair<Integer, Integer> LEAVES = Pair.of((Object)30, (Object)60);
        public static final Pair<Integer, Integer> WOOL = Pair.of((Object)30, (Object)60);
        public static final Pair<Integer, Integer> CARPET = Pair.of((Object)60, (Object)20);
        public static final Pair<Integer, Integer> FLOWER = Pair.of((Object)60, (Object)100);
    }

    public static class CompostableChance {
        public static final float SEEDS = 0.3f;
        public static final float PLANTS = 0.65f;
        public static final float BAKED_GOODS = 0.85f;
        public static final float PIES = 1.0f;
    }
}

