/*
 * Decompiled with CFR 0.152.
 */
package co.eltrut.differentiate.core.datagen.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DifferCookingRecipeBuilder {
    private final Item result;
    private final Ingredient ingredient;
    private final float experience;
    private final int cookingTime;
    private String group;
    private final CookingRecipeSerializer<?> recipeSerializer;
    private String[] mods;
    private String[] conditions;
    private String[] flags;

    public DifferCookingRecipeBuilder(IItemProvider resultIn, Ingredient ingredientIn, float experienceIn, int cookingTimeIn, CookingRecipeSerializer<?> serializer) {
        this.result = resultIn.func_199767_j();
        this.ingredient = ingredientIn;
        this.experience = experienceIn;
        this.cookingTime = cookingTimeIn;
        this.recipeSerializer = serializer;
    }

    public DifferCookingRecipeBuilder addModCompat(String ... mods) {
        this.mods = mods;
        return this;
    }

    public DifferCookingRecipeBuilder addConditions(String ... conditions) {
        this.conditions = conditions;
        return this;
    }

    public DifferCookingRecipeBuilder addFlags(String ... flags) {
        this.flags = flags;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation1 = new ResourceLocation(save);
        ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result);
        if (resourcelocation1.equals((Object)resourcelocation)) {
            throw new IllegalStateException("Recipe " + resourcelocation1 + " should remove its 'save' argument");
        }
        this.build(consumerIn, resourcelocation1);
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        consumerIn.accept(new Result(id, this.group == null ? "" : this.group, this.ingredient, this.result, this.experience, this.cookingTime, (IRecipeSerializer<? extends AbstractCookingRecipe>)this.recipeSerializer, this.mods == null ? new String[]{} : this.mods, this.conditions == null ? new String[]{} : this.conditions, this.flags == null ? new String[]{} : this.flags));
    }

    private void validate(ResourceLocation id) {
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final Item result;
        private final float experience;
        private final int cookingTime;
        private final IRecipeSerializer<? extends AbstractCookingRecipe> serializer;
        private final String[] mods;
        private final String[] conditions;
        private final String[] flags;

        public Result(ResourceLocation idIn, String groupIn, Ingredient ingredientIn, Item resultIn, float experienceIn, int cookingTimeIn, IRecipeSerializer<? extends AbstractCookingRecipe> serializerIn, String[] mods, String[] conditions, String[] flags) {
            this.id = idIn;
            this.group = groupIn;
            this.ingredient = ingredientIn;
            this.result = resultIn;
            this.experience = experienceIn;
            this.cookingTime = cookingTimeIn;
            this.serializer = serializerIn;
            this.mods = mods;
            this.conditions = conditions;
            this.flags = flags;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("ingredient", this.ingredient.func_200304_c());
            json.addProperty("result", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.result).toString());
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("cookingtime", (Number)this.cookingTime);
            if (this.conditions.length != 0 || this.mods.length != 0 || this.flags.length != 0) {
                JsonObject temp;
                JsonArray jsonarray1 = new JsonArray();
                for (String mod : this.mods) {
                    if (mod == null) continue;
                    temp = new JsonObject();
                    temp.addProperty("type", "forge:mod_loaded");
                    temp.addProperty("modid", mod);
                    jsonarray1.add((JsonElement)temp);
                }
                for (String condition : this.conditions) {
                    if (condition == null) continue;
                    temp = new JsonObject();
                    temp.addProperty("type", "differentiate:condition");
                    temp.addProperty("condition", condition);
                    jsonarray1.add((JsonElement)temp);
                }
                for (String flag : this.flags) {
                    if (flag == null) continue;
                    temp = new JsonObject();
                    temp.addProperty("type", "differentiate:flag");
                    temp.addProperty("flag", flag);
                    jsonarray1.add((JsonElement)temp);
                }
                json.add("conditions", (JsonElement)jsonarray1);
            }
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public JsonObject func_200440_c() {
            return null;
        }

        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

