/*
 * Decompiled with CFR 0.152.
 */
package co.eltrut.differentiate.core.condition;

import com.google.gson.JsonObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.fml.ModList;

public class QuarkRecipeCondition
implements ICondition {
    private final ResourceLocation location;
    private final String flag;

    public QuarkRecipeCondition(ResourceLocation location, String flag) {
        this.location = location;
        this.flag = flag;
    }

    public ResourceLocation getID() {
        return this.location;
    }

    public boolean test() {
        if (ModList.get().isLoaded("quark")) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "quark:flag");
            json.addProperty("flag", this.flag);
            return CraftingHelper.getCondition((JsonObject)json).test();
        }
        return false;
    }

    public static class Serializer
    implements IConditionSerializer<QuarkRecipeCondition> {
        private final ResourceLocation location;

        public Serializer(String name) {
            this.location = new ResourceLocation("differentiate", name);
        }

        public void write(JsonObject json, QuarkRecipeCondition value) {
            json.addProperty("flag", value.flag);
        }

        public QuarkRecipeCondition read(JsonObject json) {
            return new QuarkRecipeCondition(this.location, json.getAsJsonPrimitive("flag").getAsString());
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

