/*
 * Decompiled with CFR 0.152.
 */
package co.eltrut.differentiate.core.condition;

import com.google.gson.JsonObject;
import java.util.Hashtable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class BooleanRecipeCondition
implements ICondition {
    public static final Hashtable<String, ForgeConfigSpec.ConfigValue<Boolean>> TABLE = new Hashtable();
    private final ResourceLocation location;
    private final String condition;

    public BooleanRecipeCondition(ResourceLocation location, String condition) {
        this.location = location;
        this.condition = condition;
    }

    public ResourceLocation getID() {
        return this.location;
    }

    public boolean test() {
        return TABLE.containsKey(this.condition) && (Boolean)TABLE.get(this.condition).get() != false;
    }

    public static class Serializer
    implements IConditionSerializer<BooleanRecipeCondition> {
        private final ResourceLocation location;

        public Serializer(String name) {
            this.location = new ResourceLocation("differentiate", name);
        }

        public void write(JsonObject json, BooleanRecipeCondition value) {
            json.addProperty("condition", value.condition);
        }

        public BooleanRecipeCondition read(JsonObject json) {
            return new BooleanRecipeCondition(this.location, json.getAsJsonPrimitive("condition").getAsString());
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

