/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.lilypuree.decorative_blocks.datagen.BlockLootTableAccessor;
import com.lilypuree.decorative_blocks.datagen.types.IWoodType;
import com.lilypuree.decorative_blocks.datagen.types.ModWoodTypes;
import com.lilypuree.decorative_blocks.datagen.types.WoodDecorativeBlockTypes;
import com.lilypuree.decorative_blocks.setup.Registration;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class LootTables
extends LootTableProvider {
    private final DataGenerator generator;
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public LootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.generator = dataGeneratorIn;
    }

    public void func_200398_a(DirectoryCache cache) {
        this.addBlockLoot((Block)Registration.BAR_PANEL.get());
        this.addBlockLoot((Block)Registration.CHANDELIER.get());
        this.addBlockLoot((Block)Registration.CHAIN.get());
        this.addBlockLoot((Block)Registration.BRAZIER.get());
        this.addBlockLoot((Block)Registration.STONE_PILLAR.get());
        this.addBlockLoot((Block)Registration.ROCKY_DIRT.get());
        this.addBlockLoot((Block)Registration.SOUL_BRAZIER.get());
        this.addBlockLoot((Block)Registration.SOUL_CHANDELIER.get());
        for (IWoodType wood : ModWoodTypes.allWoodTypes()) {
            for (WoodDecorativeBlockTypes type : WoodDecorativeBlockTypes.values()) {
                this.addBlockLoot(Registration.getWoodDecorativeBlock(wood, type));
            }
        }
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
            tables.put(entry.getKey().func_220068_i(), entry.getValue().func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
        }
        this.writeTables(cache, tables);
    }

    public void writeTables(DirectoryCache cache, Map<ResourceLocation, LootTable> tables) {
        Path outputFolder = this.generator.func_200391_b();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.func_110624_b() + "/loot_tables/" + key.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void addBlockLoot(Block block) {
        this.lootTables.put(block, BlockLootTableAccessor.dropping((IItemProvider)block));
    }
}

