/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.world.gen.feature;

import com.mojang.serialization.Codec;
import com.naterbobber.darkerdepths.common.world.gen.feature.VegetationPatchConfig;
import com.naterbobber.darkerdepths.common.world.gen.feature.VegetationPatchFeature;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;

public class WaterloggedVegetationPatchFeature
extends VegetationPatchFeature {
    public WaterloggedVegetationPatchFeature(Codec<VegetationPatchConfig> config) {
        super(config);
    }

    @Override
    protected Set<BlockPos> placeGroundPatch(IWorld worldIn, VegetationPatchConfig configIn, Random rand, BlockPos pos, Predicate<BlockState> statePredicate, int xRadius, int zRadius) {
        Set<BlockPos> landGroundPatch = super.placeGroundPatch(worldIn, configIn, rand, pos, statePredicate, xRadius, zRadius);
        HashSet<BlockPos> waterGroundPatch = new HashSet<BlockPos>();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos positions : landGroundPatch) {
            if (WaterloggedVegetationPatchFeature.isSolidBlockAroundPos(worldIn, positions, mutable)) continue;
            waterGroundPatch.add(positions);
        }
        for (BlockPos positions : waterGroundPatch) {
            worldIn.func_180501_a(positions, Blocks.field_150355_j.func_176223_P(), 2);
        }
        return waterGroundPatch;
    }

    private static boolean isSolidBlockAroundPos(IWorld worldIn, BlockPos pos, BlockPos.Mutable mutable) {
        return WaterloggedVegetationPatchFeature.isSolidBlockSide(worldIn, pos, mutable, Direction.NORTH) || WaterloggedVegetationPatchFeature.isSolidBlockSide(worldIn, pos, mutable, Direction.EAST) || WaterloggedVegetationPatchFeature.isSolidBlockSide(worldIn, pos, mutable, Direction.SOUTH) || WaterloggedVegetationPatchFeature.isSolidBlockSide(worldIn, pos, mutable, Direction.WEST);
    }

    private static boolean isSolidBlockSide(IWorld worldIn, BlockPos pos, BlockPos.Mutable mutable, Direction direction) {
        mutable.func_239622_a_((Vector3i)pos, direction);
        return !worldIn.func_180495_p((BlockPos)mutable).func_224755_d((IBlockReader)worldIn, (BlockPos)mutable, direction.func_176734_d());
    }

    @Override
    protected boolean placeVegetation(ISeedReader worldIn, VegetationPatchConfig configIn, ChunkGenerator generator, Random rand, BlockPos pos) {
        if (super.placeVegetation(worldIn, configIn, generator, rand, pos.func_177977_b())) {
            BlockState state = worldIn.func_180495_p(pos);
            if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && !((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), 2);
            }
            return true;
        }
        return false;
    }
}

