/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.world.gen.feature;

import com.mojang.serialization.Codec;
import com.naterbobber.darkerdepths.common.world.gen.feature.ReplaceBlobsFeatureConfig;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class ReplaceBlobsFeature
extends Feature<ReplaceBlobsFeatureConfig> {
    public ReplaceBlobsFeature(Codec<ReplaceBlobsFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, ReplaceBlobsFeatureConfig config) {
        BlockPos distance;
        BlockPos blockPos = ReplaceBlobsFeature.moveDownToTarget((IWorld)reader, pos.func_239590_i_().func_239620_a_(Direction.Axis.Y, 1, reader.func_217301_I() - 1), config);
        if (blockPos == null) {
            return false;
        }
        int x = config.getRadius().get(rand);
        int y = config.getRadius().get(rand);
        int z = config.getRadius().get(rand);
        int radius = Math.max(x, Math.max(y, z));
        boolean shouldGenerate = false;
        Iterator iterator = BlockPos.func_239583_a_((BlockPos)blockPos, (int)x, (int)y, (int)z).iterator();
        while (iterator.hasNext() && (distance = (BlockPos)iterator.next()).func_218139_n((Vector3i)blockPos) <= radius) {
            BlockState state = reader.func_180495_p(distance);
            if (!config.target.contains(state)) continue;
            this.func_230367_a_((IWorldWriter)reader, distance, config.state);
            shouldGenerate = true;
        }
        return shouldGenerate;
    }

    @Nullable
    private static BlockPos moveDownToTarget(IWorld worldIn, BlockPos.Mutable mutable, ReplaceBlobsFeatureConfig config) {
        while (mutable.func_177956_o() > 1) {
            BlockState state = worldIn.func_180495_p((BlockPos)mutable);
            if (config.target.contains(state)) {
                return mutable;
            }
            mutable.func_189536_c(Direction.DOWN);
        }
        return null;
    }
}

