/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.math;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.naterbobber.darkerdepths.common.math.ConstantFloatProvider;
import com.naterbobber.darkerdepths.common.math.FloatProviderType;
import com.naterbobber.darkerdepths.common.math.ModRegistry;
import java.util.Random;
import java.util.function.Function;

public abstract class FloatProvider {
    private static final Codec<Either<Float, FloatProvider>> FLOAT_CODEC = Codec.either((Codec)Codec.FLOAT, (Codec)ModRegistry.FLOAT_PROVIDER_TYPE.dispatch(FloatProvider::getType, FloatProviderType::codec));
    public static final Codec<FloatProvider> CODEC = FLOAT_CODEC.xmap(either -> (FloatProvider)either.map(ConstantFloatProvider::create, provider -> provider), provider -> provider.getType() == FloatProviderType.CONSTANT ? Either.left((Object)Float.valueOf(((ConstantFloatProvider)provider).getValue())) : Either.right((Object)provider));

    public static Codec<FloatProvider> createValidatedCodec(float min, float max) {
        Function<FloatProvider, DataResult> function = provider -> {
            if (provider.getMin() < min) {
                return DataResult.error((String)("Value provider too low: " + min + " [" + provider.getMin() + "-" + provider.getMax() + "]"));
            }
            return provider.getMax() > max ? DataResult.error((String)("Value provider too high: " + max + " [" + provider.getMin() + "-" + provider.getMax() + "]")) : DataResult.success((Object)provider);
        };
        return CODEC.flatXmap(function, function);
    }

    public abstract float get(Random var1);

    public abstract float getMin();

    public abstract float getMax();

    public abstract FloatProviderType<?> getType();
}

