/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.lib.registry;

import azmalent.cuneiform.lib.registry.BlockEntry;
import azmalent.cuneiform.lib.registry.BlockRenderType;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.DeferredRegister;

public class BlockRegistryHelper {
    public final DeferredRegister<Block> blocks;
    public final DeferredRegister<Item> items;
    public final ItemGroup defaultTab;
    private final Map<BlockEntry, BlockRenderType> renderTypes = Maps.newHashMap();

    public BlockRegistryHelper(DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry, ItemGroup defaultCreativeTab) {
        this.blocks = blockRegistry;
        this.items = itemRegistry;
        this.defaultTab = defaultCreativeTab;
    }

    public BlockEntry.Builder newBuilder(String id, Supplier<? extends Block> constructor) {
        return new BlockEntry.Builder(this, id, constructor);
    }

    public BlockEntry.Builder newBuilder(String id, Function<AbstractBlock.Properties, ? extends Block> constructor, AbstractBlock.Properties properties) {
        return new BlockEntry.Builder(this, id, constructor, properties);
    }

    public BlockEntry.Builder newBuilder(String id, AbstractBlock.Properties properties) {
        return new BlockEntry.Builder(this, id, properties);
    }

    public void setRenderType(BlockEntry blockEntry, BlockRenderType renderType) {
        this.renderTypes.put(blockEntry, renderType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initRenderTypes() {
        for (Map.Entry<BlockEntry, BlockRenderType> entry : this.renderTypes.entrySet()) {
            BlockEntry blockEntry = entry.getKey();
            BlockRenderType renderType = entry.getValue();
            RenderTypeLookup.setRenderLayer((Block)blockEntry.getBlock(), (RenderType)renderType.get());
        }
    }
}

