/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.lib.config.options;

import azmalent.cuneiform.lib.config.options.AbstractConfigOption;
import azmalent.cuneiform.lib.util.StringUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;

public final class IntOption
extends AbstractConfigOption<Integer, Integer> {
    private ForgeConfigSpec.ConfigValue<Integer> value;
    private int defaultValue;
    private boolean rangeRestricted = false;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;
    private List<Integer> allowedValues;

    public IntOption(int defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public Integer get() {
        return (Integer)this.value.get();
    }

    @Override
    public void set(Integer newValue) {
        this.value.set((Object)newValue);
    }

    public IntOption nonNegative() {
        return this.inRange(0, Integer.MAX_VALUE);
    }

    public IntOption positive() {
        return this.inRange(1, Integer.MAX_VALUE);
    }

    public IntOption inRange(int min, int max) {
        this.rangeRestricted = true;
        this.min = min;
        this.max = max;
        return this;
    }

    public IntOption allowedValues(int ... allowedValues) {
        this.allowedValues = Arrays.stream(allowedValues).boxed().collect(Collectors.toList());
        return this;
    }

    @Override
    public void init(ForgeConfigSpec.Builder builder, Field field) {
        this.value = this.rangeRestricted ? this.addComment(builder, field, "Default: " + this.defaultValue).defineInRange(this.getName(field), this.defaultValue, this.min, this.max) : (this.allowedValues != null ? this.addComment(builder, field, "Default: " + this.defaultValue, "Allowed values: [" + StringUtil.joinObjects(", ", this.allowedValues) + "]").defineInList(this.getName(field), (Object)this.defaultValue, this.allowedValues) : this.addComment(builder, field, "Default: " + this.defaultValue).define(this.getName(field), (Object)this.defaultValue));
    }
}

