/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.lib.config.data;

import azmalent.cuneiform.lib.config.data.ConfigFlagManager;
import com.google.gson.JsonObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class RecipeConfigCondition
implements ICondition {
    private final String modid;
    private final String flag;
    private final ResourceLocation id;

    public RecipeConfigCondition(String modid, String flag, ResourceLocation id) {
        this.modid = modid;
        this.flag = flag;
        this.id = id;
    }

    public ResourceLocation getID() {
        return this.id;
    }

    public boolean test() {
        return ConfigFlagManager.getFlag(this.modid, this.flag);
    }

    public static class Serializer
    implements IConditionSerializer<RecipeConfigCondition> {
        private final ResourceLocation location;

        public Serializer(ResourceLocation location) {
            this.location = location;
        }

        public void write(JsonObject json, RecipeConfigCondition value) {
            json.addProperty("config", value.modid + ":" + value.flag);
        }

        public RecipeConfigCondition read(JsonObject json) {
            String[] tokens = json.getAsJsonPrimitive("config").getAsString().split(":", 2);
            return new RecipeConfigCondition(tokens[0], tokens[1], this.location);
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

