/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.filter;

import azmalent.cuneiform.CuneiformConfig;
import azmalent.cuneiform.filter.LogFilter;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class FilteringUtil {
    public static void applyLogFilter() {
        LogFilter filter = new LogFilter();
        Logger.getLogger("").setFilter(filter);
        ((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger()).addFilter((Filter)filter);
        LoggerContext logContext = (LoggerContext)LogManager.getContext((boolean)false);
        for (LoggerConfig logger : logContext.getConfiguration().getLoggers().values()) {
            logger.addFilter((Filter)filter);
        }
    }

    public static boolean shouldTruncateException(Throwable exception) {
        if (exception == null) {
            return false;
        }
        Iterator iterator = CuneiformConfig.Common.Filtering.exceptionsToTruncate.get().iterator();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            if (!clazz.isAssignableFrom(exception.getClass())) continue;
            return true;
        }
        return false;
    }

    public static void truncateException(Throwable exception) {
        if (FilteringUtil.shouldTruncateException(exception)) {
            exception.setStackTrace(new StackTraceElement[0]);
        }
    }

    public static boolean isLoggable(String message) {
        try {
            Iterator iterator = CuneiformConfig.Common.Filtering.stringsToRemove.get().iterator();
            while (iterator.hasNext()) {
                String stringToFilter = (String)iterator.next();
                if (!message.contains(stringToFilter)) continue;
                return false;
            }
            iterator = CuneiformConfig.Common.Filtering.patternsToRemove.get().iterator();
            while (iterator.hasNext()) {
                Pattern pattern = (Pattern)iterator.next();
                if (!pattern.matcher(message).find()) continue;
                return false;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return true;
    }
}

