/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.common.crafting;

import azmalent.cuneiform.Cuneiform;
import azmalent.cuneiform.lib.registry.AbstractRecipe;
import azmalent.cuneiform.lib.registry.RecipeType;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StrippingByproductRecipe
extends AbstractRecipe<RecipeWrapper> {
    public static final ResourceLocation TYPE_ID = Cuneiform.prefix("stripping_byproduct");
    public static final IRecipeType<StrippingByproductRecipe> TYPE = new RecipeType<StrippingByproductRecipe>();
    private final Block block;
    private final ItemStack output;
    private final float chance;

    public StrippingByproductRecipe(ResourceLocation id, ResourceLocation block, ItemStack output, float chance) {
        super(id);
        Preconditions.checkArgument((0.0f <= chance && chance <= 1.0f ? 1 : 0) != 0, (Object)"Chance must be between 0 and 1");
        this.block = (Block)ForgeRegistries.BLOCKS.getValue(block);
        this.output = output;
        this.chance = chance;
    }

    public boolean matches(BlockState state) {
        return state.func_203425_a(this.block);
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public float getChance() {
        return this.chance;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Serializer.INSTANCE;
    }

    public IRecipeType<?> func_222127_g() {
        return TYPE;
    }

    public static class Serializer
    extends AbstractRecipe.Serializer<StrippingByproductRecipe> {
        public static Serializer INSTANCE = new Serializer();

        public StrippingByproductRecipe read(ResourceLocation id, JsonObject json) {
            ResourceLocation block = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"block"));
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"));
            float chance = 1.0f;
            if (json.has("chance")) {
                chance = JSONUtils.func_151217_k((JsonObject)json, (String)"chance");
            }
            return new StrippingByproductRecipe(id, block, output, chance);
        }

        @Nullable
        public StrippingByproductRecipe read(ResourceLocation id, PacketBuffer buffer) {
            return new StrippingByproductRecipe(id, buffer.func_192575_l(), buffer.func_150791_c(), buffer.readFloat());
        }

        public void write(PacketBuffer buffer, StrippingByproductRecipe recipe) {
            buffer.func_192572_a(recipe.block.getRegistryName());
            buffer.func_150788_a(recipe.output);
            buffer.writeFloat(recipe.chance);
        }
    }
}

