/*
 * Decompiled with CFR 0.152.
 */
package net.ncpbails.culturaldelights.tileentity;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.ncpbails.culturaldelights.data.recipes.ModRecipeTypes;
import net.ncpbails.culturaldelights.tileentity.ModTileEntities;
import net.ncpbails.culturaldelights.util.ModTags;

public class BambooMatTile
extends TileEntity
implements ITickableTileEntity {
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);

    public BambooMatTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public BambooMatTile() {
        this((TileEntityType)ModTileEntities.BAMBOO_MAT_TILE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.itemHandler.deserializeNBT(nbt.func_74775_l("inv"));
        super.func_230337_a_(state, nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("inv", (INBT)this.itemHandler.serializeNBT());
        return super.func_189515_b(compound);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(7){

            protected void onContentsChanged(int slot) {
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void craft() {
        Inventory inv = new Inventory(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inv.func_70299_a(i, this.itemHandler.getStackInSlot(i));
        }
        Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(ModRecipeTypes.MAT_ROLLING_RECIPE, (IInventory)inv, this.field_145850_b);
        recipe.ifPresent(iRecipe -> {
            ItemStack output = iRecipe.func_77571_b();
            this.craftTheItem(output);
            this.outcomeTaken();
            this.func_70296_d();
        });
    }

    private void craftTheItem(ItemStack output) {
        this.itemHandler.insertItem(5, output, false);
    }

    private void removeOutput(ItemStack output) {
        this.itemHandler.extractItem(5, 64, false);
    }

    private void outcomeTaken() {
        this.giveBowls();
        this.giveBottles();
        this.giveBuckets();
        this.itemHandler.extractItem(0, 1, false);
        this.itemHandler.extractItem(1, 1, false);
        this.itemHandler.extractItem(2, 1, false);
        this.itemHandler.extractItem(3, 1, false);
        this.itemHandler.extractItem(4, 1, false);
    }

    private void giveBowls() {
        Inventory inv = new Inventory(this.itemHandler.getSlots());
        Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(ModRecipeTypes.MAT_ROLLING_RECIPE, (IInventory)inv, this.field_145850_b);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (!this.itemHandler.getStackInSlot(i).func_77973_b().func_206844_a(ModTags.Items.BOWL_FOODS) || this.field_145850_b.func_201670_d()) continue;
            ItemEntity entityToSpawn = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), new ItemStack((IItemProvider)Items.field_151054_z));
            entityToSpawn.func_174867_a(10);
            this.field_145850_b.func_217376_c((Entity)entityToSpawn);
        }
    }

    private void giveBottles() {
        Inventory inv = new Inventory(this.itemHandler.getSlots());
        Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(ModRecipeTypes.MAT_ROLLING_RECIPE, (IInventory)inv, this.field_145850_b);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (!this.itemHandler.getStackInSlot(i).func_77973_b().func_206844_a(ModTags.Items.BOTTLE_FOODS) || this.field_145850_b.func_201670_d()) continue;
            ItemEntity entityToSpawn = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), new ItemStack((IItemProvider)Items.field_151069_bo));
            entityToSpawn.func_174867_a(10);
            this.field_145850_b.func_217376_c((Entity)entityToSpawn);
        }
    }

    private void giveBuckets() {
        Inventory inv = new Inventory(this.itemHandler.getSlots());
        Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(ModRecipeTypes.MAT_ROLLING_RECIPE, (IInventory)inv, this.field_145850_b);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (!this.itemHandler.getStackInSlot(i).func_77973_b().func_206844_a(ModTags.Items.BUCKET_FOODS) || this.field_145850_b.func_201670_d()) continue;
            ItemEntity entityToSpawn = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), new ItemStack((IItemProvider)Items.field_151133_ar));
            entityToSpawn.func_174867_a(10);
            this.field_145850_b.func_217376_c((Entity)entityToSpawn);
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.craft();
    }
}

