/*
 * Decompiled with CFR 0.152.
 */
package net.ncpbails.culturaldelights;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.ncpbails.culturaldelights.block.ModBlocks;
import net.ncpbails.culturaldelights.container.ModContainers;
import net.ncpbails.culturaldelights.data.recipes.ModRecipeTypes;
import net.ncpbails.culturaldelights.item.ModItems;
import net.ncpbails.culturaldelights.screen.BambooMatScreen;
import net.ncpbails.culturaldelights.tileentity.ModTileEntities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vectorwing.farmersdelight.mixin.accessors.ChickenEntityAccessor;

@Mod(value="culturaldelights")
public class CulturalDelights {
    public static final String MOD_ID = "culturaldelights";
    private static final Logger LOGGER = LogManager.getLogger();

    public CulturalDelights() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.register(eventBus);
        ModBlocks.register(eventBus);
        ModTileEntities.register(eventBus);
        ModContainers.register(eventBus);
        ModRecipeTypes.register(eventBus);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::enqueueIMC);
        eventBus.addListener(this::processIMC);
        eventBus.addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AxeItem.field_203176_a = new ImmutableMap.Builder().putAll(AxeItem.field_203176_a).put((Object)ModBlocks.AVOCADO_LOG.get(), (Object)Blocks.field_203207_U).put((Object)ModBlocks.AVOCADO_WOOD.get(), (Object)Blocks.field_209392_ae).build();
        });
        event.enqueueWork(() -> {
            CulturalDelights.registerCompostables();
            ArrayList<ItemStack> chickenFood = new ArrayList<ItemStack>();
            Collections.addAll(chickenFood, ChickenEntityAccessor.getFoodItems().func_193365_a());
            chickenFood.add(new ItemStack((IItemProvider)ModItems.CUCUMBER_SEEDS.get()));
            chickenFood.add(new ItemStack((IItemProvider)ModItems.CORN_KERNELS.get()));
            chickenFood.add(new ItemStack((IItemProvider)ModItems.EGGPLANT_SEEDS.get()));
            chickenFood.add(new ItemStack((IItemProvider)ModItems.WHITE_EGGPLANT_SEEDS.get()));
            ChickenEntityAccessor.setFoodItems((Ingredient)Ingredient.func_234819_a_(chickenFood.stream()));
        });
    }

    public static void registerCompostables() {
        ComposterBlock.field_220299_b.put((Object)ModItems.CUCUMBER_SEEDS.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)ModItems.CORN_KERNELS.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)ModItems.EGGPLANT_SEEDS.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)ModItems.WHITE_EGGPLANT_SEEDS.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)ModBlocks.AVOCADO_PIT.get(), 0.3f);
        ComposterBlock.field_220299_b.put((Object)ModItems.CUT_CUCUMBER.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.CUT_AVOCADO.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.CUT_EGGPLANT.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.AVOCADO.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.CUCUMBER.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.CORN_COB.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.EGGPLANT.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.WHITE_EGGPLANT.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModBlocks.WILD_CUCUMBERS.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModBlocks.WILD_CORN.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModBlocks.WILD_EGGPLANTS.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModBlocks.AVOCADO_LEAVES.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModBlocks.AVOCADO_SAPLING.get(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)ModItems.POPCORN.get(), 0.85f);
        ComposterBlock.field_220299_b.put((Object)ModBlocks.AVOCADO_BUNDLE.get(), 0.65f);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.BAMBOO_MAT.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.WILD_CUCUMBERS.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.WILD_CORN.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.WILD_EGGPLANTS.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.AVOCADO_LEAVES.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.AVOCADO_SAPLING.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.AVOCADO_PIT.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CUCUMBERS.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.EGGPLANTS.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.WHITE_EGGPLANTS.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CORN.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CORN_UPPER.get()), (RenderType)RenderType.func_228641_d_());
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.BAMBOO_MAT_CONTAINER.get()), BambooMatScreen::new);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LOGGER.info("HELLO from Register Block");
        }
    }
}

