/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.copperpot.common.tile;

import com.davigj.copperpot.common.blocks.CopperPotBlock;
import com.davigj.copperpot.common.crafting.CopperPotRecipe;
import com.davigj.copperpot.common.tile.container.CopperPotContainer;
import com.davigj.copperpot.common.tile.inventory.CopperPotItemHandler;
import com.davigj.copperpot.common.utils.tags.CopperPotTags;
import com.davigj.copperpot.core.CopperPotConfig;
import com.davigj.copperpot.core.registry.CopperPotTileEntityTypes;
import com.davigj.copperpot.core.utils.TextUtils;
import java.util.Iterator;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.utils.tags.ModTags;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CopperPotTileEntity
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity,
INameable {
    public static final int MEAL_DISPLAY_SLOT = 3;
    public static final int CONTAINER_SLOT = 4;
    public static final int OUTPUT_SLOT = 5;
    public static final int INVENTORY_SIZE = 6;
    private ItemStackHandler itemHandler = this.createHandler();
    private LazyOptional<IItemHandler> handlerInput = LazyOptional.of(() -> new CopperPotItemHandler((IItemHandler)this.itemHandler, Direction.UP));
    private LazyOptional<IItemHandler> handlerOutput = LazyOptional.of(() -> new CopperPotItemHandler((IItemHandler)this.itemHandler, Direction.DOWN));
    private ITextComponent customName;
    private int cookTime;
    private int cookTimeTotal;
    private ItemStack container;
    private boolean effectTrue;
    protected final IIntArray copperPotData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return CopperPotTileEntity.this.cookTime;
                }
                case 1: {
                    return CopperPotTileEntity.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    CopperPotTileEntity.this.cookTime = value;
                    break;
                }
                case 1: {
                    CopperPotTileEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };
    protected final IRecipeType<? extends CopperPotRecipe> recipeType;

    public CopperPotTileEntity(TileEntityType<?> tileEntityTypeIn, IRecipeType<? extends CopperPotRecipe> recipeTypeIn) {
        super(tileEntityTypeIn);
        this.recipeType = recipeTypeIn;
        this.container = ItemStack.field_190927_a;
    }

    public CopperPotTileEntity() {
        this((TileEntityType)CopperPotTileEntityTypes.COPPER_POT_TILE.get(), CopperPotRecipe.TYPE);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.writeItems(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    private void inventoryChanged() {
        super.func_70296_d();
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.itemHandler.deserializeNBT(compound.func_74775_l("Inventory"));
        this.cookTime = compound.func_74762_e("CookTime");
        this.cookTimeTotal = compound.func_74762_e("CookTimeTotal");
        this.container = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Container"));
        this.effectTrue = compound.func_74767_n("EffectTrue");
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("CustomName"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        compound.func_218657_a("Container", (INBT)this.container.serializeNBT());
        compound.func_74757_a("EffectTrue", this.effectTrue);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        compound.func_218657_a("Inventory", (INBT)this.itemHandler.serializeNBT());
        return compound;
    }

    private CompoundNBT writeItems(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("Container", (INBT)this.container.serializeNBT());
        compound.func_218657_a("Inventory", (INBT)this.itemHandler.serializeNBT());
        return compound;
    }

    public CompoundNBT writeMeal(CompoundNBT compound) {
        if (this.getMeal().func_190926_b()) {
            return compound;
        }
        ItemStackHandler drops = new ItemStackHandler(6);
        for (int i = 0; i < 6; ++i) {
            drops.setStackInSlot(i, i == 3 ? this.itemHandler.getStackInSlot(i) : ItemStack.field_190927_a);
        }
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        compound.func_218657_a("Container", (INBT)this.container.serializeNBT());
        compound.func_218657_a("Inventory", (INBT)drops.serializeNBT());
        return compound;
    }

    private static Supplier<Effect> getCookEffect(String modid, ResourceLocation effect) {
        return ModList.get().isLoaded(modid) ? () -> (Effect)ForgeRegistries.POTIONS.getValue(effect) : () -> null;
    }

    private void effectCloud(World worldIn, BlockPos pos) {
        AreaEffectCloudEntity steam = new AreaEffectCloudEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5);
        steam.func_184486_b(15);
        steam.func_184483_a(0.1f);
        String effect = this.getEffect();
        int effectDuration = this.getEffectDuration();
        int effectAmplifier = this.getEffectAmplifier();
        String[] effectName = effect.split(":", 2);
        EffectInstance effectInstance = new EffectInstance(CopperPotTileEntity.getCookEffect(effectName[0], new ResourceLocation(effectName[0], effectName[1])).get(), effectDuration, effectAmplifier, false, true);
        double radius = this.fumesRadius(worldIn, pos);
        for (LivingEntity living : steam.field_70170_p.func_217357_a(LivingEntity.class, steam.func_174813_aQ().func_72314_b(radius, 2.0, radius))) {
            living.func_195064_c(effectInstance);
        }
        steam.func_184496_a(effectInstance);
        worldIn.func_217376_c((Entity)steam);
    }

    private double fumesRadius(World worldIn, BlockPos pos) {
        Iterator var8 = BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 3, 1)).iterator();
        double inhibited = (Double)CopperPotConfig.COMMON.copperFumeRadius.get();
        while (var8.hasNext()) {
            BlockPos neighborPos = (BlockPos)var8.next();
            BlockState neighborState = worldIn.func_180495_p(neighborPos);
            if (neighborState.func_235714_a_(CopperPotTags.PARTIAL_FUME_INHIBITORS)) {
                inhibited = 1.0;
            }
            if (!neighborState.func_235714_a_(CopperPotTags.FUME_INHIBITORS)) continue;
            return 0.0;
        }
        return inhibited;
    }

    public void func_73660_a() {
        boolean isHeated = this.isAboveLitHeatSource();
        boolean dirty = false;
        World worldIn = this.field_145850_b;
        BlockPos pos = this.field_174879_c;
        if (!this.field_145850_b.field_72995_K) {
            if (isHeated && this.hasInput() && ((Boolean)this.func_195044_w().func_177229_b((Property)CopperPotBlock.ENABLED)).booleanValue()) {
                CopperPotRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)new RecipeWrapper((IItemHandlerModifiable)this.itemHandler), this.field_145850_b).orElse(null);
                if (this.canCook(irecipe)) {
                    ++this.cookTime;
                    if (this.cookTime % 30 == 0 && this.isEffectTrue()) {
                        this.effectCloud(worldIn, pos);
                    }
                    if (this.cookTime == this.cookTimeTotal) {
                        this.cookTime = 0;
                        this.cookTimeTotal = this.getCookTime();
                        this.cook(irecipe);
                        dirty = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            ItemStack meal = this.getMeal();
            if (!meal.func_190926_b()) {
                if (!this.doesMealHaveContainer(meal)) {
                    this.moveMealToOutput();
                    dirty = true;
                } else if (!this.itemHandler.getStackInSlot(4).func_190926_b()) {
                    this.useStoredContainersOnMeal();
                    dirty = true;
                }
            }
        } else if (isHeated) {
            this.animate();
        }
        if (dirty) {
            this.inventoryChanged();
        }
    }

    protected int getCookTime() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)new RecipeWrapper((IItemHandlerModifiable)this.itemHandler), this.field_145850_b).map(CopperPotRecipe::getCookTime).orElse(100);
    }

    protected ItemStack getRecipeContainer() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)new RecipeWrapper((IItemHandlerModifiable)this.itemHandler), this.field_145850_b).map(CopperPotRecipe::getOutputContainer).orElse(ItemStack.field_190927_a);
    }

    public ItemStack getContainer() {
        return !this.container.func_190926_b() ? this.container : this.getMeal().getContainerItem();
    }

    public boolean isEffectTrue() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)new RecipeWrapper((IItemHandlerModifiable)this.itemHandler), this.field_145850_b).map(CopperPotRecipe::getEffectTrue).orElse(false);
    }

    public String getEffect() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)new RecipeWrapper((IItemHandlerModifiable)this.itemHandler), this.field_145850_b).map(CopperPotRecipe::getEffect).orElse("");
    }

    public int getEffectDuration() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)new RecipeWrapper((IItemHandlerModifiable)this.itemHandler), this.field_145850_b).map(CopperPotRecipe::getEffectDuration).orElse(100);
    }

    public int getEffectAmplifier() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)new RecipeWrapper((IItemHandlerModifiable)this.itemHandler), this.field_145850_b).map(CopperPotRecipe::getEffectAmplifier).orElse(0);
    }

    private boolean hasInput() {
        for (int i = 0; i < 3; ++i) {
            if (this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    protected boolean canCook(@Nullable IRecipe<?> recipeIn) {
        if (this.hasInput() && recipeIn != null) {
            ItemStack recipeOutput = recipeIn.func_77571_b();
            if (recipeOutput.func_190926_b()) {
                return false;
            }
            ItemStack currentOutput = this.itemHandler.getStackInSlot(3);
            if (currentOutput.func_190926_b()) {
                return true;
            }
            if (!currentOutput.func_77969_a(recipeOutput)) {
                return false;
            }
            if (currentOutput.func_190916_E() + recipeOutput.func_190916_E() <= Math.min(16, this.itemHandler.getSlotLimit(3))) {
                return true;
            }
            return currentOutput.func_190916_E() + recipeOutput.func_190916_E() <= Math.min(16, recipeOutput.func_77976_d());
        }
        return false;
    }

    private void cook(@Nullable IRecipe<?> recipe) {
        if (recipe != null && this.canCook(recipe)) {
            this.container = this.getRecipeContainer();
            ItemStack recipeOutput = recipe.func_77571_b();
            ItemStack currentOutput = this.itemHandler.getStackInSlot(3);
            if (currentOutput.func_190926_b()) {
                this.itemHandler.setStackInSlot(3, recipeOutput.func_77946_l());
            } else if (currentOutput.func_77973_b() == recipeOutput.func_77973_b()) {
                currentOutput.func_190917_f(recipeOutput.func_190916_E());
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (this.itemHandler.getStackInSlot(i).hasContainerItem()) {
                Direction direction = ((Direction)this.func_195044_w().func_177229_b((Property)CopperPotBlock.field_185512_D)).func_176735_f();
                double dropX = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)direction.func_82601_c() * 0.25;
                double dropY = (double)this.field_174879_c.func_177956_o() + 0.7;
                double dropZ = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)direction.func_82599_e() * 0.25;
                ItemEntity entity = new ItemEntity(this.field_145850_b, dropX, dropY, dropZ, this.itemHandler.getStackInSlot(i).getContainerItem());
                entity.func_213293_j((double)((float)direction.func_82601_c() * 0.08f), 0.25, (double)((float)direction.func_82599_e() * 0.08f));
                this.field_145850_b.func_217376_c((Entity)entity);
            }
            if (this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            this.itemHandler.getStackInSlot(i).func_190918_g(1);
        }
    }

    private void animate() {
        World world = this.func_145831_w();
        if (world != null) {
            double baseZ;
            double baseY;
            double baseX;
            BlockPos blockpos = this.func_174877_v();
            Random random = world.field_73012_v;
            if (random.nextFloat() < 0.07f) {
                baseX = (double)blockpos.func_177958_n() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
                baseY = (double)blockpos.func_177956_o() + 0.4;
                baseZ = (double)blockpos.func_177952_p() + 0.5 + (random.nextDouble() * 0.6 - 0.3);
                world.func_195594_a((IParticleData)ParticleTypes.field_197614_g, baseX, baseY, baseZ, 0.0, 0.0, 0.0);
            }
            if (random.nextFloat() < 0.03f) {
                baseX = (double)blockpos.func_177958_n() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                baseY = (double)blockpos.func_177956_o() + 0.4;
                baseZ = (double)blockpos.func_177952_p() + 0.5 + (random.nextDouble() * 0.4 - 0.2);
                world.func_195594_a((IParticleData)ParticleTypes.field_197620_m, baseX, baseY, baseZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public ItemStack getMeal() {
        return this.itemHandler.getStackInSlot(3);
    }

    public boolean isAboveLitHeatSource() {
        if (this.field_145850_b == null) {
            return false;
        }
        BlockState checkState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        if (ModTags.HEAT_SOURCES.func_230235_a_((Object)checkState.func_177230_c())) {
            return checkState.func_235901_b_((Property)BlockStateProperties.field_208190_q) ? (Boolean)checkState.func_177229_b((Property)BlockStateProperties.field_208190_q) : true;
        }
        return false;
    }

    public NonNullList<ItemStack> getDroppableInventory() {
        NonNullList drops = NonNullList.func_191196_a();
        for (int i = 0; i < 6; ++i) {
            drops.add((Object)(i == 3 ? ItemStack.field_190927_a : this.itemHandler.getStackInSlot(i)));
        }
        return drops;
    }

    private void moveMealToOutput() {
        ItemStack mealDisplay = this.itemHandler.getStackInSlot(3);
        ItemStack finalOutput = this.itemHandler.getStackInSlot(5);
        int mealCount = Math.min(mealDisplay.func_190916_E(), mealDisplay.func_77976_d() - finalOutput.func_190916_E());
        if (finalOutput.func_190926_b()) {
            this.itemHandler.setStackInSlot(5, mealDisplay.func_77979_a(mealCount));
        } else if (finalOutput.func_77973_b() == mealDisplay.func_77973_b()) {
            mealDisplay.func_190918_g(mealCount);
            finalOutput.func_190917_f(mealCount);
        }
    }

    private void useStoredContainersOnMeal() {
        ItemStack mealDisplay = this.itemHandler.getStackInSlot(3);
        ItemStack containerInput = this.itemHandler.getStackInSlot(4);
        ItemStack finalOutput = this.itemHandler.getStackInSlot(5);
        if (this.isContainerValid(containerInput) && finalOutput.func_190916_E() < finalOutput.func_77976_d()) {
            int smallerStack = Math.min(mealDisplay.func_190916_E(), containerInput.func_190916_E());
            int mealCount = Math.min(smallerStack, mealDisplay.func_77976_d() - finalOutput.func_190916_E());
            if (finalOutput.func_190926_b()) {
                containerInput.func_190918_g(mealCount);
                this.itemHandler.setStackInSlot(5, mealDisplay.func_77979_a(mealCount));
            } else if (finalOutput.func_77973_b() == mealDisplay.func_77973_b()) {
                mealDisplay.func_190918_g(mealCount);
                containerInput.func_190918_g(mealCount);
                finalOutput.func_190917_f(mealCount);
            }
        }
    }

    public ItemStack useHeldItemOnMeal(ItemStack container) {
        if (this.isContainerValid(container) && !this.getMeal().func_190926_b()) {
            container.func_190918_g(1);
            return this.getMeal().func_77979_a(1);
        }
        return ItemStack.field_190927_a;
    }

    private boolean doesMealHaveContainer(ItemStack meal) {
        return !this.container.func_190926_b() || meal.hasContainerItem();
    }

    public boolean isContainerValid(ItemStack containerItem) {
        if (containerItem.func_190926_b()) {
            return false;
        }
        return !this.container.func_190926_b() ? this.container.func_77969_a(containerItem) : this.getMeal().getContainerItem().func_77969_a(containerItem);
    }

    public ItemStackHandler getInventory() {
        return this.itemHandler;
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : TextUtils.getTranslation("container.copper_pot", new Object[0]);
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public Container createMenu(int id, PlayerInventory player, PlayerEntity entity) {
        return new CopperPotContainer(id, player, this, this.copperPotData);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                if (slot >= 0 && slot < 3) {
                    CopperPotTileEntity.this.cookTimeTotal = CopperPotTileEntity.this.getCookTime();
                    CopperPotTileEntity.this.inventoryChanged();
                }
            }
        };
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return side != null && !side.equals((Object)Direction.UP) ? this.handlerOutput.cast() : this.handlerInput.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.handlerInput.invalidate();
        this.handlerOutput.invalidate();
    }
}

