/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.copperpot.common.items;

import com.davigj.copperpot.core.registry.CopperPotItems;
import com.davigj.copperpot.core.utils.TextUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.utils.MathUtils;

public class RoyalJelly
extends Item {
    private static final List<EffectInstance> EFFECTS = Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance(Effects.field_76444_x, 1200, 1), new EffectInstance(Effects.field_76429_m, 1200, 1), new EffectInstance(Effects.field_76424_c, 1200, 0)});

    public RoyalJelly(Item.Properties properties) {
        super(properties);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IFormattableTextComponent textWhenFeeding = TextUtils.getTranslation("tooltip.royal_jelly.when_feeding", new Object[0]);
        IFormattableTextComponent textWhenEating = TextUtils.getTranslation("tooltip.royal_jelly.when_eating", new Object[0]);
        tooltip.add((ITextComponent)textWhenEating.func_240699_a_(TextFormatting.BLUE));
        tooltip.add((ITextComponent)textWhenFeeding.func_240699_a_(TextFormatting.GRAY));
        for (EffectInstance effectInstance : EFFECTS) {
            StringTextComponent effectDescription = new StringTextComponent(" ");
            TranslationTextComponent effectName = new TranslationTextComponent(effectInstance.func_76453_d());
            effectDescription.func_230529_a_((ITextComponent)effectName);
            Effect effect = effectInstance.func_188419_a();
            if (effectInstance.func_76458_c() > 0) {
                effectDescription.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("potion.potency." + effectInstance.func_76458_c()));
            }
            if (effectInstance.func_76459_b() > 20) {
                effectDescription.func_240702_b_(" (").func_240702_b_(EffectUtils.func_188410_a((EffectInstance)effectInstance, (float)1.0f)).func_240702_b_(")");
            }
            tooltip.add((ITextComponent)effectDescription.func_240699_a_(effect.func_220303_e().func_220306_a()));
        }
        IFormattableTextComponent textWhenBeeing = TextUtils.getTranslation("tooltip.royal_jelly.fix_bee", new Object[0]);
        tooltip.add((ITextComponent)textWhenBeeing.func_240699_a_(TextFormatting.BLUE));
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        super.func_77654_b(stack, worldIn, entityLiving);
        if (!worldIn.field_72995_K) {
            this.fliparoo(entityLiving);
        }
        return stack;
    }

    public void fliparoo(LivingEntity entity) {
        for (EffectInstance effect : entity.func_70651_bq()) {
            if (effect.func_76459_b() <= 10 || !effect.func_76453_d().equals("effect.minecraft.poison")) continue;
            entity.func_195064_c(new EffectInstance(Effects.field_76428_l, (int)((double)effect.func_76459_b() * 0.33), Math.max(effect.func_76458_c() - 2, 0), effect.func_82720_e(), effect.func_188418_e(), effect.func_205348_f()));
        }
        entity.func_195063_d(Effects.field_76436_u);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        BeeEntity bee;
        if (target instanceof BeeEntity && ((bee = (BeeEntity)target).func_70089_S() || bee.func_226412_eE_())) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private static Supplier<Effect> getCompatEffect(String modid, ResourceLocation effect) {
        return ModList.get().isLoaded(modid) ? () -> (Effect)ForgeRegistries.POTIONS.getValue(effect) : () -> null;
    }

    @Mod.EventBusSubscriber(modid="copperpot", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class beeFeedEvent {
        @SubscribeEvent
        public static void onRoyalJellyApplied(PlayerInteractEvent.EntityInteract event) {
            BeeEntity entity;
            PlayerEntity player = event.getPlayer();
            Entity target = event.getTarget();
            ItemStack itemStack = event.getItemStack();
            if (target instanceof BeeEntity && (entity = (BeeEntity)target).func_70089_S() && itemStack.func_77973_b().equals(CopperPotItems.ROYAL_JELLY.get())) {
                entity.func_70606_j(entity.func_110138_aP());
                entity.func_226449_s_(false);
                if (entity.func_70631_g_()) {
                    entity.func_175501_a(120, true);
                }
                beeFeedEvent.beeFx(entity);
                entity.func_230260_a__(0);
                entity.field_70170_p.func_184133_a((PlayerEntity)null, target.func_233580_cy_(), SoundEvents.field_187537_bA, SoundCategory.PLAYERS, 0.5f, 1.4f);
                for (int i = 0; i < 5; ++i) {
                    double d0 = MathUtils.RAND.nextGaussian() * 0.02;
                    double d1 = MathUtils.RAND.nextGaussian() * 0.02;
                    double d2 = MathUtils.RAND.nextGaussian() * 0.02;
                    entity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_229428_ah_, entity.func_226282_d_(1.0), entity.func_226279_cv_() + 0.5, entity.func_226287_g_(1.0), d0, d1, d2);
                }
                if (!player.func_184812_l_()) {
                    itemStack.func_190918_g(1);
                }
                event.setCancellationResult(ActionResultType.SUCCESS);
                event.setCanceled(true);
            }
        }

        private static void beeFx(BeeEntity entity) {
            List list = EFFECTS;
            for (EffectInstance effect : list) {
                entity.func_195064_c(new EffectInstance(effect));
            }
        }
    }
}

