/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.copperpot.common.items;

import com.davigj.copperpot.core.CopperPotConfig;
import com.davigj.copperpot.core.utils.TextUtils;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Mooncake
extends Item {
    Logger LOGGER = LogManager.getLogger((String)"copperpot");

    public Mooncake(Item.Properties properties) {
        super(properties);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        super.func_77654_b(stack, worldIn, entityLiving);
        for (String i : (List)CopperPotConfig.COMMON.mooncakeBadReactDims.get()) {
            if (entityLiving.func_130014_f_().func_230315_m_().func_242725_p().toString().equals(i)) {
                entityLiving.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f);
                entityLiving.func_195064_c(new EffectInstance(Effects.field_76436_u, 480));
                continue;
            }
            this.moonlight(entityLiving, worldIn);
        }
        return stack;
    }

    private static Supplier<Effect> getCompatEffect(String modid, ResourceLocation effect) {
        return ModList.get().isLoaded(modid) ? () -> (Effect)ForgeRegistries.POTIONS.getValue(effect) : () -> null;
    }

    public void moonlight(LivingEntity entity, World worldIn) {
        long daytime = worldIn.func_72820_D() % 24000L;
        long moonProxTime = Math.abs(daytime - 6000L);
        double moon = Math.abs(4 - worldIn.func_242414_af());
        if (moonProxTime > 12000L) {
            moonProxTime = Math.abs(24000L - moonProxTime);
        }
        moon = worldIn.func_72935_r() ? 0.7 : 1.0 + 0.1 * moon;
        if (ModList.get().isLoaded("neapolitan")) {
            entity.func_195064_c(new EffectInstance(new EffectInstance(Mooncake.getCompatEffect("neapolitan", new ResourceLocation("neapolitan", "harmony")).get(), (int)(0.11 * (double)moonProxTime * moon))));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IFormattableTextComponent tip = TextUtils.getTranslation("tooltip.mooncake.tip", new Object[0]);
        tooltip.add((ITextComponent)tip.func_240699_a_(TextFormatting.BLUE));
    }
}

