/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.copperpot.common.items;

import com.davigj.copperpot.core.utils.TextUtils;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class MintMeringue
extends Item {
    String effect1;
    String effect2;

    public MintMeringue(Item.Properties properties, String effect1, String effect2) {
        super(properties);
        this.effect1 = effect1;
        this.effect2 = effect2;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        super.func_77654_b(stack, worldIn, entityLiving);
        if (!worldIn.field_72995_K) {
            double rand = Math.random();
            if (ModList.get().isLoaded("neapolitan")) {
                if (rand < 0.7) {
                    entityLiving.func_195064_c(new EffectInstance(MintMeringue.getCompatEffect("neapolitan", new ResourceLocation("neapolitan", "berserking")).get(), 100, 0));
                }
                if (rand > 0.3) {
                    entityLiving.func_195064_c(new EffectInstance(new EffectInstance(MintMeringue.getCompatEffect("neapolitan", new ResourceLocation("neapolitan", "sugar_rush")).get(), 140, 0)));
                    this.extendEffect(entityLiving);
                }
            }
        }
        return stack;
    }

    private static Supplier<Effect> getCompatEffect(String modid, ResourceLocation effect) {
        return ModList.get().isLoaded(modid) ? () -> (Effect)ForgeRegistries.POTIONS.getValue(effect) : () -> null;
    }

    public void extendEffect(LivingEntity player) {
        for (EffectInstance effect : player.func_70651_bq()) {
            double rand = Math.random();
            if ((effect == null || effect.func_76459_b() <= 10 || !effect.func_76453_d().equals(this.effect1)) && !effect.func_76453_d().equals(this.effect2)) continue;
            if (rand < 0.4) {
                player.func_195064_c(new EffectInstance(effect.func_188419_a(), effect.func_76459_b() + 240, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e(), effect.func_205348_f()));
                continue;
            }
            if (!(rand > Math.min(0.7, (double)(1 / (effect.func_76458_c() + 1))))) continue;
            player.func_195064_c(new EffectInstance(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c() + 1, effect.func_82720_e(), effect.func_188418_e(), effect.func_205348_f()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IFormattableTextComponent tip = TextUtils.getTranslation("tooltip.mint_meringue.tip", new Object[0]);
        IFormattableTextComponent tip2 = TextUtils.getTranslation("tooltip.mint_meringue.tip2", new Object[0]);
        tooltip.add((ITextComponent)tip.func_240699_a_(TextFormatting.BLUE));
        tooltip.add((ITextComponent)tip2.func_240699_a_(TextFormatting.BLUE));
    }
}

