/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.copperpot.common.integration.jei;

import com.davigj.copperpot.client.gui.CopperPotScreen;
import com.davigj.copperpot.common.crafting.CopperPotRecipe;
import com.davigj.copperpot.common.integration.jei.cooking.CookingRecipeCategory;
import com.davigj.copperpot.common.tile.container.CopperPotContainer;
import com.davigj.copperpot.core.registry.CopperPotBlocks;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("copperpot", "jei_plugin");
    private static final Minecraft MC = Minecraft.func_71410_x();

    private static List<IRecipe<?>> findRecipesByType(IRecipeType<?> type) {
        return JEIPlugin.MC.field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_222127_g() == type).collect(Collectors.toList());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new CookingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(JEIPlugin.findRecipesByType(CopperPotRecipe.TYPE), CookingRecipeCategory.UID);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)((Block)CopperPotBlocks.COPPER_POT.get()).func_199767_j()), new ResourceLocation[]{CookingRecipeCategory.UID});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CopperPotScreen.class, 89, 25, 24, 17, new ResourceLocation[]{CookingRecipeCategory.UID});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(CopperPotContainer.class, CookingRecipeCategory.UID, 0, 3, 6, 36);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

