/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.copperpot.common.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BreakableBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MeringueBlock
extends BreakableBlock {
    protected static final VoxelShape SHAPES = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    Logger field_196273_d = LogManager.getLogger((String)"copperpot");

    public MeringueBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (this.isRiding(entityIn)) {
            this.Ride(entityIn);
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    private boolean isRiding(Entity entity) {
        Vector3d vector3d = entity.func_213322_ci();
        return Math.abs(vector3d.field_72448_b) > 0.1;
    }

    private void Ride(Entity entity) {
        Vector3d vector3d = entity.func_213322_ci();
        double amp = 0.0;
        if (entity instanceof LivingEntity) {
            if (entity instanceof PlayerEntity) {
                EffectInstance[] effects = new EffectInstance[]{((PlayerEntity)entity).func_70660_b(Effects.field_76424_c), ((PlayerEntity)entity).func_70660_b(Effects.field_76430_j), ((PlayerEntity)entity).func_70660_b(Effects.field_204839_B), ((PlayerEntity)entity).func_70660_b(Effects.field_76421_d)};
                for (int currentEffect = 0; currentEffect < 4; ++currentEffect) {
                    if (effects[currentEffect] == null) continue;
                    if (currentEffect < 2) {
                        amp = effects[currentEffect].func_76458_c() + 1;
                        continue;
                    }
                    amp -= (double)(effects[currentEffect].func_76458_c() + 1);
                }
            }
            if (((LivingEntity)entity).field_70703_bu && vector3d.field_72448_b > 0.0) {
                if (Math.abs(vector3d.field_72448_b) < 0.3 + amp * 0.1) {
                    entity.func_213317_d(new Vector3d(vector3d.field_72450_a, Math.max(vector3d.field_72448_b, vector3d.field_72448_b + (amp + 1.0) * 0.1), vector3d.field_72449_c));
                } else {
                    entity.func_213317_d(new Vector3d(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c));
                }
                if (Math.random() > 0.99) {
                    entity.func_184185_a(SoundEvents.field_226140_eU_, 0.4f, 1.1f);
                }
            } else if (vector3d.field_72448_b < 0.0) {
                if (amp >= 0.0) {
                    entity.func_213317_d(new Vector3d(vector3d.field_72450_a, -0.1, vector3d.field_72449_c));
                }
                if (amp < 0.0) {
                    entity.func_213317_d(new Vector3d(vector3d.field_72450_a, Math.min(0.03, -0.03 - amp * 0.1), vector3d.field_72449_c));
                }
                if (Math.random() > 0.99) {
                    entity.func_184185_a(SoundEvents.field_226140_eU_, 0.4f, 1.1f);
                }
            }
            entity.field_70143_R = 0.0f;
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_184185_a(SoundEvents.field_226136_eQ_, 0.6f, 1.0f);
        if (entityIn.func_225503_b_(fallDistance, 0.3f)) {
            entityIn.func_184185_a(this.field_149762_H.func_185842_g(), this.field_149762_H.func_185843_a() * 0.6f, this.field_149762_H.func_185847_b() * 0.75f);
        }
    }
}

