/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.copperpot.common.blocks;

import com.davigj.copperpot.common.tile.CopperPotTileEntity;
import com.davigj.copperpot.core.registry.CopperPotTileEntityTypes;
import com.davigj.copperpot.core.utils.TextUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vectorwing.farmersdelight.registry.ModSounds;
import vectorwing.farmersdelight.utils.MathUtils;
import vectorwing.farmersdelight.utils.tags.ModTags;

public class CopperPotBlock
extends HorizontalBlock
implements IWaterLoggable {
    public static final BooleanProperty SUPPORTED = BlockStateProperties.field_208150_C;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty ENABLED = BlockStateProperties.field_208180_g;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0);
    protected static final VoxelShape SHAPE_SUPPORTED = VoxelShapes.func_197872_a((VoxelShape)SHAPE, (VoxelShape)Block.func_208617_a((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));
    Logger field_196273_d = LogManager.getLogger((String)"copperpot");

    public CopperPotBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)SUPPORTED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)SUPPORTED) != false ? SHAPE_SUPPORTED : SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        World world = context.func_195991_k();
        FluidState ifluidstate = world.func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)SUPPORTED, (Comparable)Boolean.valueOf(this.needsTrayForHeatSource(world.func_180495_p(blockpos.func_177977_b()))))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a))).func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing == Direction.DOWN ? (BlockState)stateIn.func_206870_a((Property)SUPPORTED, (Comparable)Boolean.valueOf(this.needsTrayForHeatSource(facingState))) : stateIn;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c())) {
            this.updateState(worldIn, pos, state);
        }
    }

    private boolean needsTrayForHeatSource(BlockState state) {
        return state.func_177230_c().func_203417_a((ITag)ModTags.TRAY_HEAT_SOURCES);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult result) {
        if (!worldIn.field_72995_K) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof CopperPotTileEntity) {
                ItemStack serving = ((CopperPotTileEntity)tile).useHeldItemOnMeal(player.func_184586_b(handIn));
                if (serving != ItemStack.field_190927_a) {
                    if (!player.field_71071_by.func_70441_a(serving)) {
                        player.func_71019_a(serving, false);
                    }
                    worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187719_p, SoundCategory.BLOCKS, 1.0f, 1.0f);
                } else {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((CopperPotTileEntity)tile), (BlockPos)pos);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.func_185473_a(worldIn, pos, state);
        CopperPotTileEntity tile = (CopperPotTileEntity)worldIn.func_175625_s(pos);
        CompoundNBT compoundnbt = tile.writeMeal(new CompoundNBT());
        if (!compoundnbt.isEmpty()) {
            itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
        }
        if (tile.func_145818_k_()) {
            itemstack.func_200302_a(tile.func_200201_e());
        }
        return itemstack;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.updateState(worldIn, pos, state);
    }

    private void updateState(World worldIn, BlockPos pos, BlockState state) {
        boolean flag;
        boolean bl = flag = !worldIn.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((Property)ENABLED)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(flag)), 4);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof CopperPotTileEntity) {
                InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, ((CopperPotTileEntity)tileentity).getDroppableInventory());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null) {
            CompoundNBT inventoryTag = compoundnbt.func_74775_l("Inventory");
            if (inventoryTag.func_150297_b("Items", 9)) {
                ItemStackHandler handler = new ItemStackHandler();
                handler.deserializeNBT(inventoryTag);
                ItemStack meal = handler.getStackInSlot(3);
                if (!meal.func_190926_b()) {
                    IFormattableTextComponent servingsOf = meal.func_190916_E() == 1 ? TextUtils.getTranslation("tooltip.copper_pot.single_serving", new Object[0]) : TextUtils.getTranslation("tooltip.copper_pot.many_servings", meal.func_190916_E());
                    tooltip.add((ITextComponent)servingsOf.func_240699_a_(TextFormatting.GRAY));
                    IFormattableTextComponent mealName = meal.func_200301_q().func_230532_e_();
                    tooltip.add((ITextComponent)mealName.func_240699_a_(meal.func_77953_t().field_77937_e));
                }
            }
        } else {
            IFormattableTextComponent empty = TextUtils.getTranslation("tooltip.copper_pot.empty", new Object[0]);
            tooltip.add((ITextComponent)empty.func_240699_a_(TextFormatting.GRAY));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{field_185512_D, SUPPORTED, WATERLOGGED, ENABLED});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof CopperPotTileEntity) {
            ((CopperPotTileEntity)tileentity).setCustomName(stack.func_200301_q());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof CopperPotTileEntity && ((CopperPotTileEntity)tileentity).isAboveLitHeatSource()) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = pos.func_177956_o();
            double d2 = (double)pos.func_177952_p() + 0.5;
            if (rand.nextInt(10) == 0) {
                worldIn.func_184134_a(d0, d1, d2, (SoundEvent)ModSounds.BLOCK_COOKING_POT_BOIL.get(), SoundCategory.BLOCKS, 0.4f, rand.nextFloat() * 0.2f + 0.9f, false);
            }
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof CopperPotTileEntity) {
            ItemStackHandler inventory = ((CopperPotTileEntity)tile).getInventory();
            return MathUtils.calcRedstoneFromItemHandler((IItemHandlerModifiable)inventory);
        }
        return 0;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)CopperPotTileEntityTypes.COPPER_POT_TILE.get()).func_200968_a();
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

