/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.copperpot.common.blocks;

import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class BakedAlaskaBlock
extends Block {
    public static final IntegerProperty BITES = IntegerProperty.func_177719_a((String)"bites", (int)0, (int)3);
    public static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    public BakedAlaskaBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            ItemStack itemstack = player.func_184586_b(handIn);
            if (this.eatSlice((IWorld)worldIn, pos, state, player).func_226246_a_()) {
                return ActionResultType.SUCCESS;
            }
            if (itemstack.func_190926_b()) {
                return ActionResultType.CONSUME;
            }
        }
        return this.eatSlice((IWorld)worldIn, pos, state, player);
    }

    private ActionResultType eatSlice(IWorld world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!player.func_71043_e(false)) {
            return ActionResultType.PASS;
        }
        player.func_195066_a(Stats.field_188076_J);
        player.func_71024_bL().func_75122_a(3, 0.2f);
        int i = (Integer)state.func_177229_b((Property)BITES);
        if (i < 3) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            world.func_217377_a(pos, false);
        }
        if (!world.func_201670_d()) {
            double random = Math.random();
            if (random < 0.33) {
                player.func_195064_c(new EffectInstance(BakedAlaskaBlock.getCompatEffect("neapolitan", new ResourceLocation("neapolitan", "sugar_rush")).get(), 200, 2));
            } else if (random < 0.66 && random > 0.33) {
                player.func_195064_c(new EffectInstance(BakedAlaskaBlock.getCompatEffect("neapolitan", new ResourceLocation("neapolitan", "vanilla_scent")).get(), 100));
            } else if (random > 0.66 && random < 0.77) {
                player.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 1));
            } else {
                player.func_70691_i(4.0f);
            }
        }
        return ActionResultType.SUCCESS;
    }

    private static Supplier<Effect> getCompatEffect(String modid, ResourceLocation effect) {
        return ModList.get().isLoaded(modid) ? () -> (Effect)ForgeRegistries.POTIONS.getValue(effect) : () -> null;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, BITES});
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (4 - (Integer)blockState.func_177229_b((Property)BITES)) * 2;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
    }
}

