/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.combustivefishing.common.entity;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import top.theillusivec4.combustivefishing.common.entity.AbstractLavaFishEntity;
import top.theillusivec4.combustivefishing.common.entity.ai.FollowLavaSchoolLeaderGoal;

public abstract class AbstractLavaGroupFishEntity
extends AbstractLavaFishEntity {
    private AbstractLavaGroupFishEntity groupLeader;
    private int groupSize = 1;

    public AbstractLavaGroupFishEntity(EntityType<? extends AbstractLavaGroupFishEntity> type, World world) {
        super((EntityType<? extends AbstractLavaFishEntity>)type, world);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowLavaSchoolLeaderGoal(this));
    }

    @Override
    public int func_70641_bl() {
        return this.getMaxGroupSize();
    }

    public int getMaxGroupSize() {
        return super.func_70641_bl();
    }

    @Override
    protected boolean func_212800_dy() {
        return !this.hasGroupLeader();
    }

    public boolean hasGroupLeader() {
        return this.groupLeader != null && this.groupLeader.func_70089_S();
    }

    public AbstractLavaGroupFishEntity joinGroup(AbstractLavaGroupFishEntity leader) {
        this.groupLeader = leader;
        leader.increaseGroupSize();
        return leader;
    }

    public void leaveGroup() {
        this.groupLeader.decreaseGroupSize();
        this.groupLeader = null;
    }

    private void increaseGroupSize() {
        ++this.groupSize;
    }

    private void decreaseGroupSize() {
        --this.groupSize;
    }

    public boolean canGroupGrow() {
        return this.isGroupLeader() && this.groupSize < this.getMaxGroupSize();
    }

    public void func_70071_h_() {
        List list;
        super.func_70071_h_();
        if (this.isGroupLeader() && this.field_70170_p.field_73012_v.nextInt(200) == 1 && (list = this.field_70170_p.func_217357_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0))).size() <= 1) {
            this.groupSize = 1;
        }
    }

    public boolean isGroupLeader() {
        return this.groupSize > 1;
    }

    public boolean inRangeOfGroupLeader() {
        return this.func_70068_e((Entity)this.groupLeader) <= 121.0;
    }

    public void moveToGroupLeader() {
        if (this.hasGroupLeader()) {
            this.func_70661_as().func_75497_a((Entity)this.groupLeader, 1.0);
        }
    }

    public void func_212810_a(Stream<AbstractLavaGroupFishEntity> p_212810_1_) {
        p_212810_1_.limit(this.getMaxGroupSize() - this.groupSize).filter(p_212801_1_ -> p_212801_1_ != this).forEach(p_212804_1_ -> p_212804_1_.joinGroup(this));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (spawnDataIn == null) {
            spawnDataIn = new GroupData(this);
        } else {
            this.joinGroup(((GroupData)spawnDataIn).field_212822_a);
        }
        return spawnDataIn;
    }

    public static class GroupData
    implements ILivingEntityData {
        public final AbstractLavaGroupFishEntity field_212822_a;

        public GroupData(AbstractLavaGroupFishEntity p_i49858_1_) {
            this.field_212822_a = p_i49858_1_;
        }
    }
}

