/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.data.GlobalVariables;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;

public class StringFunctions {
    public static void sendMessage(CommandSource source, String m, TextFormatting colour) {
        StringFunctions.sendMessage(source, m, colour, false);
    }

    public static void sendMessage(PlayerEntity player, String m, TextFormatting colour) {
        StringFunctions.sendMessage(player, m, colour, false);
    }

    public static void sendMessage(CommandSource source, String m, TextFormatting colour, boolean emptyline) {
        StringFunctions.sendMessage(source, m, colour, emptyline, "");
    }

    public static void sendMessage(PlayerEntity player, String m, TextFormatting colour, boolean emptyline) {
        StringFunctions.sendMessage(player, m, colour, emptyline, "");
    }

    public static void sendMessage(CommandSource source, String m, TextFormatting colour, String url) {
        StringFunctions.sendMessage(source, m, colour, false, url);
    }

    public static void sendMessage(PlayerEntity player, String m, TextFormatting colour, String url) {
        StringFunctions.sendMessage(player, m, colour, false, url);
    }

    public static void sendMessage(CommandSource source, String m, TextFormatting colour, boolean emptyline, String url) {
        if (m.isEmpty()) {
            return;
        }
        if (emptyline) {
            source.func_197030_a((ITextComponent)new StringTextComponent(""), true);
        }
        StringTextComponent message = new StringTextComponent(m);
        message.func_240699_a_(colour);
        if (m.contains("http") || !url.isEmpty()) {
            if (url.isEmpty()) {
                for (String word : m.split(" ")) {
                    if (!word.contains("http")) continue;
                    url = word;
                    break;
                }
            }
            if (!url.isEmpty()) {
                Style clickstyle = message.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
                message.func_240703_c_(clickstyle);
            }
        }
        source.func_197030_a((ITextComponent)message, true);
    }

    public static void sendMessage(PlayerEntity player, String m, TextFormatting colour, boolean emptyline, String url) {
        if (m.isEmpty()) {
            return;
        }
        if (emptyline) {
            player.func_145747_a((ITextComponent)new StringTextComponent(""), player.func_110124_au());
        }
        StringTextComponent message = new StringTextComponent(m);
        message.func_240699_a_(colour);
        if (m.contains("http") || !url.isEmpty()) {
            if (url.isEmpty()) {
                for (String word : m.split(" ")) {
                    if (!word.contains("http")) continue;
                    url = word;
                    break;
                }
            }
            if (!url.isEmpty()) {
                Style clickstyle = message.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
                message.func_240703_c_(clickstyle);
            }
        }
        player.func_145747_a((ITextComponent)message, player.func_110124_au());
    }

    public static void broadcastMessage(World world, String m, TextFormatting colour) {
        if (m.isEmpty()) {
            return;
        }
        StringTextComponent message = new StringTextComponent(m);
        message.func_240699_a_(colour);
        MinecraftServer server = world.func_73046_m();
        if (server == null) {
            return;
        }
        for (PlayerEntity player : server.func_184103_al().func_181057_v()) {
            StringFunctions.sendMessage(player, m, colour);
        }
    }

    public static void sendMessageToPlayersAround(World world, BlockPos p, int radius, String message, TextFormatting colour) {
        if (message.isEmpty()) {
            return;
        }
        for (Entity around : world.func_72839_b(null, new AxisAlignedBB((double)(p.func_177958_n() - radius), (double)(p.func_177956_o() - radius), (double)(p.func_177952_p() - radius), (double)(p.func_177958_n() + radius), (double)(p.func_177956_o() + radius), (double)(p.func_177952_p() + radius)))) {
            if (!(around instanceof PlayerEntity)) continue;
            StringFunctions.sendMessage((PlayerEntity)around, message, colour);
        }
    }

    public static String capitalizeFirst(String string) {
        StringBuilder sb = new StringBuilder(string);
        for (int i = 0; i < sb.length(); ++i) {
            if (i != 0 && sb.charAt(i - 1) != ' ') continue;
            sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
        }
        return sb.toString();
    }

    public static String capitalizeEveryWord(String text) {
        if (text.length() == 0) {
            return text;
        }
        char[] chars = text.toLowerCase().toCharArray();
        boolean found = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!found && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                found = true;
                continue;
            }
            if (Character.isDigit(chars[i]) || Character.isLetter(chars[i])) continue;
            found = false;
        }
        return String.valueOf(chars);
    }

    public static String escapeSpecialRegexChars(String str) {
        return Pattern.compile("[{}()\\[\\].+*?^$\\\\|]").matcher(str).replaceAll("\\\\$0");
    }

    public static String getRandomName(boolean malenames, boolean femalenames) {
        List<String> allnames;
        if (malenames && femalenames) {
            allnames = Stream.concat(GlobalVariables.femalenames.stream(), GlobalVariables.malenames.stream()).collect(Collectors.toList());
        } else if (femalenames) {
            allnames = GlobalVariables.femalenames;
        } else if (malenames) {
            allnames = GlobalVariables.malenames;
        } else {
            return "";
        }
        String name = allnames.get(GlobalVariables.random.nextInt(allnames.size())).toLowerCase();
        return StringFunctions.capitalizeEveryWord(name);
    }

    public static String getPCLocalTime(boolean twentyfour, boolean showseconds) {
        LocalDateTime now = LocalDateTime.now();
        String time = showseconds ? (twentyfour ? now.format(DateTimeFormatter.ofPattern("HH:mm:ss")) : now.format(DateTimeFormatter.ofPattern("hh:mm:ss a"))) : (twentyfour ? now.format(DateTimeFormatter.ofPattern("HH:mm")) : now.format(DateTimeFormatter.ofPattern("hh:mm a")));
        return time;
    }

    public static int sequenceCount(String text, String sequence) {
        Pattern pattern = Pattern.compile(sequence);
        Matcher matcher = pattern.matcher(text);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static String joinListWithCommaAnd(List<String> inputlist) {
        if (inputlist.size() == 0) {
            return "";
        }
        if (inputlist.size() == 1) {
            return inputlist.get(0);
        }
        ArrayList<String> list = new ArrayList<String>(inputlist);
        String lastelement = (String)list.get(list.size() - 1);
        list.remove(list.size() - 1);
        String initial = String.join((CharSequence)", ", list);
        return initial + " and " + lastelement;
    }
}

