/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.data.common.loot;

import com.blackgear.cavesandcliffs.core.registries.CCBItems;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBEntityTypes;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.conditions.KilledByPlayer;
import net.minecraft.loot.conditions.RandomChanceWithLooting;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class EntityLootTableGenerator
implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
    private static final Set<EntityType<?>> NO_DROPS = ImmutableSet.of((Object)EntityType.field_200729_aH, (Object)EntityType.field_200789_c, (Object)EntityType.field_200757_aw, (Object)EntityType.field_200745_ak, (Object)EntityType.field_200756_av);
    private final Map<ResourceLocation, LootTable.Builder> lootTables = Maps.newHashMap();

    protected void addTables() {
        this.registerLootTable((EntityType)CCBEntityTypes.GLOW_SQUID.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)CCBItems.GLOW_INK_SAC.get())).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
        this.registerLootTable((EntityType)CCBEntityTypes.AXOLOTL.get(), LootTable.func_216119_b());
        this.registerLootTable((EntityType)CCBEntityTypes.GOAT.get(), LootTable.func_216119_b());
        this.registerLootTable(EntityType.field_204724_o, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151078_bh).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)CCBItems.COPPER_INGOT.get()))).func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.05f, (float)0.01f))));
    }

    @Override
    public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
        this.addTables();
        HashSet set = Sets.newHashSet();
        for (EntityType<?> entities : this.getKnownEntities()) {
            ResourceLocation resourceLocation = entities.func_220348_g();
            if (!resourceLocation.func_110624_b().equals("cavesandcliffs")) continue;
            if (this.isNonLiving(entities)) {
                if (resourceLocation == LootTables.field_186419_a || this.lootTables.remove(resourceLocation) == null) continue;
                throw new IllegalStateException(String.format("Weird loottable '%s' for '%s', not a LivingEntity so should not have loot", resourceLocation, Registry.field_212629_r.func_177774_c(entities)));
            }
            if (resourceLocation == LootTables.field_186419_a || !set.add(resourceLocation)) continue;
            LootTable.Builder builder = this.lootTables.remove(resourceLocation);
            if (builder == null) {
                throw new IllegalStateException(String.format("Missing loottable '%s' for '%s'", resourceLocation, Registry.field_212629_r.func_177774_c(entities)));
            }
            consumer.accept(resourceLocation, builder);
        }
        this.lootTables.forEach(consumer);
    }

    protected Iterable<EntityType<?>> getKnownEntities() {
        return Registry.field_212629_r;
    }

    protected boolean isNonLiving(EntityType<?> entitytype) {
        return !NO_DROPS.contains(entitytype) && entitytype.func_220339_d() == EntityClassification.MISC;
    }

    protected void registerLootTable(EntityType<?> type, LootTable.Builder table) {
        this.registerLootTable(type.func_220348_g(), table);
    }

    protected void registerLootTable(ResourceLocation id, LootTable.Builder table) {
        this.lootTables.put(id, table);
    }
}

