/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.api;

import com.blackgear.cavesandcliffs.core.api.CoreRegistries;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.fml.RegistryObject;

public class Registries
extends CoreRegistries {
    public RegistryObject<SoundEvent> registerSoundEvent(String key) {
        return this.soundEvents.register(key, () -> new SoundEvent(new ResourceLocation("cavesandcliffs", key)));
    }

    public RegistryObject<BasicParticleType> registerParticle(String key, boolean alwaysShow) {
        return this.particleTypes.register(key, () -> new BasicParticleType(alwaysShow));
    }

    public <T extends IParticleData, P extends ParticleType<T>> void registerParticleFactory(RegistryObject<P> particle, ParticleManager.IParticleMetaFactory<T> factory) {
        if (particle.isPresent()) {
            Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)particle.get(), factory);
        }
    }

    public <U> RegistryObject<MemoryModuleType<U>> registerMemoryModuleType(String key, Codec<U> codec) {
        return this.memoryModuleTypes.register(key, () -> new MemoryModuleType(Optional.of(codec)));
    }

    public <U> RegistryObject<MemoryModuleType<U>> registerMemoryModuleType(String key) {
        return this.memoryModuleTypes.register(key, () -> new MemoryModuleType(Optional.empty()));
    }

    public RegistryObject<Activity> registerActivity(String key) {
        return this.activities.register(key, () -> new Activity(key));
    }

    public <C extends IFeatureConfig, F extends Feature<C>> RegistryObject<F> registerFeature(String key, Supplier<? extends F> feature) {
        return this.features.register(key, feature);
    }

    public <C extends IFeatureConfig, F extends Feature<C>, CF extends ConfiguredFeature<C, F>> CF registerConfiguredFeature(String key, CF configuredFeature) {
        ResourceLocation feature = new ResourceLocation("cavesandcliffs", key);
        if (WorldGenRegistries.field_243653_e.func_148742_b().contains(feature)) {
            throw new IllegalStateException("The Configured Feature " + key + "already exists in the registry");
        }
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)feature, configuredFeature);
        return configuredFeature;
    }

    public <P extends BlockStateProvider> RegistryObject<BlockStateProviderType<P>> registerBlockStateProviderType(String key, Codec<P> blockStateProvider) {
        return this.blockStateProviderTypes.register(key, () -> new BlockStateProviderType(blockStateProvider));
    }

    public <T extends IPlacementConfig, G extends Placement<T>> RegistryObject<G> registerPlacement(String key, Supplier<G> placement) {
        return this.placements.register(key, placement);
    }

    public <P extends FoliagePlacer> RegistryObject<FoliagePlacerType<P>> registerFoliagePlacerType(String key, Codec<P> foliagePlacer) {
        return this.foliagePlacerTypes.register(key, () -> new FoliagePlacerType(foliagePlacer));
    }

    public <B extends Biome> RegistryObject<B> registerBiome(String key, Supplier<? extends B> biome) {
        return this.biomes.register(key, biome);
    }
}

