/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cavesandcliffs")
public class CavesAndCliffsConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec COMMON;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GENERATE_COPPER_ORE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GENERATE_TUFF;
    public static final ForgeConfigSpec.ConfigValue<Integer> TUFF_SPAWN_WEIGHT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GENERATE_DEEPSLATE;
    public static final ForgeConfigSpec.ConfigValue<Integer> DEEPSLATE_SPAWN_WEIGHT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GENERATE_DEEPSLATE_ORES;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GENERATE_AMETHYST_GEODES;
    public static final ForgeConfigSpec.ConfigValue<String> AMETHYST_GEODE_CASING_BLOCK;
    public static final ForgeConfigSpec.ConfigValue<Integer> AMETHYST_GEODE_SPAWN_RARITY;
    public static final ForgeConfigSpec.ConfigValue<Integer> AMETHYST_GEODE_MAX_HEIGHT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GENERATE_GLOW_LICHEN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DRIPSTONE_CAVE_LARGE_COPPER_BLOBS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GENERATE_AZALEA_TREES;
    public static final ForgeConfigSpec.ConfigValue<Integer> AZALEA_TREE_GENERATION_RARITY;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GENERATE_DRIPSTONE_CAVES;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GENERATE_LUSH_CAVES;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GENERATE_GLOW_SQUIDS;
    public static final ForgeConfigSpec.ConfigValue<Integer> GLOW_SQUID_SPAWN_WEIGHT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> LEGACY_GLOW_SQUID_GENERATION;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GENERATE_AXOLOTLS;
    public static final ForgeConfigSpec.ConfigValue<Integer> AXOLOTL_SPAWN_WEIGHT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> LEGACY_AXOLOTL_GENERATION;
    public static final ForgeConfigSpec.ConfigValue<Boolean> GENERATE_GOATS;
    public static final ForgeConfigSpec.ConfigValue<Integer> GOAT_SPAWN_WEIGHT;
    public static final ForgeConfigSpec.ConfigValue<Boolean> RAW_ORE_DROPS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> RAW_ORE_FOR_EXTERNAL_COPPER;
    public static final ForgeConfigSpec.ConfigValue<Boolean> MONSTERS_SPAWN_IN_TOTAL_DARKNESS;
    public static final ForgeConfigSpec.ConfigValue<Integer> PANORAMA_VALUE;

    static {
        BUILDER.push("World Generation");
        BUILDER.push("Ore Generation");
        BUILDER.push("Copper Settings");
        GENERATE_COPPER_ORE = BUILDER.comment("Determines if Copper should generate so it doesn't interfere with other modded copper.").define("GenerateCopperOre", true);
        DRIPSTONE_CAVE_LARGE_COPPER_BLOBS = BUILDER.comment("Determines if Large Copper Blobs should generate in Dripstone Caves.").define("DripstoneCaveLargeCopperBlobs", true);
        BUILDER.pop();
        BUILDER.push("Tuff Settings");
        GENERATE_TUFF = BUILDER.comment("Determines if Tuff Blobs should generate underground.").define("GenerateTuff", true);
        TUFF_SPAWN_WEIGHT = BUILDER.comment("Determines the weight of spawning for Tuff.").define("TuffSpawnWeight", (Object)1);
        BUILDER.pop();
        BUILDER.push("Deepslate Settings");
        GENERATE_DEEPSLATE = BUILDER.comment("Determines if Deepslate Blobs should generate underground.").define("GenerateDeepslate", true);
        DEEPSLATE_SPAWN_WEIGHT = BUILDER.comment("Determines the weight of spawning for Deepslate.").define("DeepslateSpawnWeight", (Object)2);
        GENERATE_DEEPSLATE_ORES = BUILDER.comment("Determines if Deepslate Ores should generate underground.").define("GenerateDeepslateOres", true);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Feature Generation");
        BUILDER.push("Amethyst Geodes Settings");
        GENERATE_AMETHYST_GEODES = BUILDER.comment("Determines if Amethyst Geodes should generate underground.").define("GenerateAmethystGeodes", true);
        AMETHYST_GEODE_CASING_BLOCK = BUILDER.comment("Determines what block should generate as the casing for Amethyst Geodes").define("AmethystGeodeCasingBlock", (Object)"cavesandcliffs:smooth_basalt");
        AMETHYST_GEODE_SPAWN_RARITY = BUILDER.comment("Determines the rarity of spawning for Amethyst Geodes.").define("AmethystGeodesSpawnRarity", (Object)24);
        AMETHYST_GEODE_MAX_HEIGHT = BUILDER.comment("Determines the max height of spawning for Amethyst Geodes.").define("AmethystGeodesMaxHeight", (Object)30);
        BUILDER.pop();
        BUILDER.push("Azalea Tree Settings");
        GENERATE_AZALEA_TREES = BUILDER.comment("Determines if Azalea Trees should generate in the surface.").define("GenerateAzaleaTrees", true);
        AZALEA_TREE_GENERATION_RARITY = BUILDER.comment("Determines the rarity of spawning for Azalea Trees.").define("AzaleaTreeGenerationRarity", (Object)2);
        BUILDER.pop();
        GENERATE_GLOW_LICHEN = BUILDER.comment("Determines if Glow Lichen should generate underground.").define("GenerateGlowLichen", true);
        BUILDER.pop();
        BUILDER.push("Biome Generation");
        GENERATE_DRIPSTONE_CAVES = BUILDER.comment("Determines if Dripstone Caves should generate underground. \nNOTE: using TERRAFORGED worldtype will prevent this biome to spawn.").define("GenerateDripstoneCaves", true);
        GENERATE_LUSH_CAVES = BUILDER.comment("Determines if Lush Caves should generate underground. \nNOTE: using TERRAFORGED worldtype will prevent this biome to spawn.").define("GenerateLushCaves", true);
        BUILDER.pop();
        BUILDER.push("Entity Generation");
        BUILDER.push("Glow Squid Settings");
        GENERATE_GLOW_SQUIDS = BUILDER.comment("Determines if Glow Squids should generate.").define("GenerateGlowSquids", true);
        GLOW_SQUID_SPAWN_WEIGHT = BUILDER.comment("Determines the weight of spawning for Glow Squids.").define("GlowSquidSpawnWeight", (Object)10);
        LEGACY_GLOW_SQUID_GENERATION = BUILDER.comment("Determines if Glow Squids should generate as in 1.17.").define("LegacyGlowSquidGeneration", false);
        BUILDER.pop();
        BUILDER.push("Axolotl Settings");
        GENERATE_AXOLOTLS = BUILDER.comment("Determines if Axolotls should generate.").define("GenerateAxolotls", true);
        AXOLOTL_SPAWN_WEIGHT = BUILDER.comment("Determines the weight of spawning for Axolotls").define("AxolotlSpawnWeight", (Object)10);
        LEGACY_AXOLOTL_GENERATION = BUILDER.comment("Determines if Axolotls should generate as in 1.17. \nIn 1.18 they can generate in clay pools inside of LUSH CAVES.").define("LegacyAxolotlGeneration", false);
        BUILDER.pop();
        BUILDER.push("Goat Settings");
        GENERATE_GOATS = BUILDER.comment("Determines if Goats should generate.").define("GenerateGoats", true);
        GOAT_SPAWN_WEIGHT = BUILDER.comment("Determines the weight of spawning for Goats.").define("GoatSpawnWeight", (Object)10);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Gameplay Settings");
        BUILDER.push("Raw Ore Settings");
        RAW_ORE_DROPS = BUILDER.comment("Determines if Iron, Gold and Copper should drop Raw Ores.").define("RawOreDrops", true);
        RAW_ORE_FOR_EXTERNAL_COPPER = BUILDER.comment("Determines if Copper from other mods should also drop Raw Copper.").define("RawOreDropsForExternalCopper", false);
        BUILDER.pop();
        MONSTERS_SPAWN_IN_TOTAL_DARKNESS = BUILDER.comment("Determines if monsters should only spawn where the light value equals zero.").define("MonstersSpawnInTotalDarkness", true);
        BUILDER.pop();
        BUILDER.push("Client Settings");
        PANORAMA_VALUE = BUILDER.comment("Determines the Value for the Panorama to display. \nThis option can alternate the panorama in the main menu by using numbers. \n0 = default panoramic view. \n1 = part I panoramic view. \n2 = part II panoramic view.").defineInRange("PanoramaValue", 1, 0, 2);
        BUILDER.pop();
        COMMON = BUILDER.build();
    }
}

