/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core;

import com.blackgear.cavesandcliffs.client.renderer.RenderManager;
import com.blackgear.cavesandcliffs.common.EntityManager;
import com.blackgear.cavesandcliffs.common.world.CCBWorldGeneration;
import com.blackgear.cavesandcliffs.core.CavesAndCliffsConfig;
import com.blackgear.cavesandcliffs.core.api.Registries;
import com.blackgear.cavesandcliffs.core.other.BlockInteraction;
import com.blackgear.cavesandcliffs.core.other.conditions.QuarkRecipeCondition;
import com.blackgear.cavesandcliffs.core.other.tags.CCBBlockTags;
import com.blackgear.cavesandcliffs.core.other.tags.CCBEntityTypeTags;
import com.blackgear.cavesandcliffs.core.other.tags.CCBItemTags;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.CCBItems;
import com.blackgear.cavesandcliffs.core.registries.CCBLootFunctions;
import com.blackgear.cavesandcliffs.core.registries.CCBLootModifiers;
import com.blackgear.cavesandcliffs.core.registries.CCBPointOfInterestTypes;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBEntityTypes;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBSensorTypes;
import com.blackgear.cavesandcliffs.core.registries.worldgen.CCBStructurePieces;
import com.blackgear.cavesandcliffs.core.registries.worldgen.CCBStructures;
import com.blackgear.cavesandcliffs.core.registries.worldgen.CCBSurfaceBuilders;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cavesandcliffs")
public class CavesAndCliffs {
    public static final String MODID = "cavesandcliffs";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Registries REGISTRIES = new Registries();

    public CavesAndCliffs() {
        CCBBlockTags.init();
        CCBItemTags.init();
        CCBEntityTypeTags.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        REGISTRIES.initializeRegistries(FMLJavaModLoadingContext.get().getModEventBus());
        CraftingHelper.register((IConditionSerializer)new QuarkRecipeCondition.Serializer());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CavesAndCliffsConfig.COMMON);
        this.registrySetup(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        RenderManager.registerBlockRenderers();
        RenderManager.registerEntityRenderers();
        RenderManager.renderPanorama();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        EntityManager.registerSpawnPlacements();
        CCBPointOfInterestTypes.registerPointsOfInterest();
        CCBWorldGeneration.registerBiomeGeneration();
        CCBSurfaceBuilders.Configured.registerConfiguredSurfaceBuilders();
        BlockInteraction.bootstrap();
    }

    private void registrySetup(IEventBus bus) {
        CCBBlocks.BLOCKS.register(bus);
        CCBItems.ITEMS.register(bus);
        CCBEntityTypes.ENTITIES.register(bus);
        CCBSensorTypes.SENSOR_TYPES.register(bus);
        CCBLootModifiers.LOOT_MODIFIERS.register(bus);
        CCBPointOfInterestTypes.POI_TYPES.register(bus);
        CCBStructures.bootstrap();
        CCBStructurePieces.init();
        CCBLootFunctions.init();
    }
}

