/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.other;

import com.blackgear.cavesandcliffs.common.math.MathUtils;
import com.blackgear.cavesandcliffs.core.registries.worldgen.CCBBlockStateProviderTypes;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;

public class MeadowFlowerProvider
extends BlockStateProvider {
    public static final Codec<MeadowFlowerProvider> CODEC;
    private static final BlockState[] FLOWERS;
    public static final MeadowFlowerProvider PROVIDER;

    protected BlockStateProviderType<?> func_230377_a_() {
        return (BlockStateProviderType)CCBBlockStateProviderTypes.MEADOW_FLOWER_PROVIDER.get();
    }

    public BlockState func_225574_a_(Random randomIn, BlockPos blockPosIn) {
        double noise = Biome.field_180281_af.func_215464_a((double)blockPosIn.func_177958_n() * 5.0E-4, (double)blockPosIn.func_177952_p() * 5.0E-4, false);
        int lerp = (int)MathUtils.lerpFromProgress(noise, -1.0, 1.0, 1.0, 4.0);
        ArrayList flowers = Lists.newArrayList();
        for (int index = 0; index < lerp; ++index) {
            int i = this.getFlowerIndex(blockPosIn.func_177982_a(index * 234349, 0, 0), FLOWERS.length, 5.0E-4);
            flowers.add(FLOWERS[i]);
        }
        return (BlockState)flowers.get(this.getFlowerIndex(blockPosIn, flowers.size(), 0.1));
    }

    private int getFlowerIndex(BlockPos pos, int flowerId, double range) {
        double noise = Biome.field_180281_af.func_215464_a((double)pos.func_177958_n() * range, (double)pos.func_177952_p() * range, false);
        double clamp = MathHelper.func_151237_a((double)((1.0 + noise) / 2.0), (double)0.0, (double)1.0);
        return (int)(clamp * (double)flowerId);
    }

    static {
        FLOWERS = new BlockState[]{Blocks.field_196804_gh.func_176223_P(), Blocks.field_196609_bf.func_176223_P(), Blocks.field_196606_bd.func_176223_P(), Blocks.field_196610_bg.func_176223_P(), Blocks.field_196605_bc.func_176223_P(), Blocks.field_222387_by.func_176223_P(), Blocks.field_196616_bl.func_176223_P(), Blocks.field_150349_c.func_176223_P()};
        PROVIDER = new MeadowFlowerProvider();
        CODEC = Codec.unit(() -> PROVIDER);
    }
}

