/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.math.MathUtils;
import com.blackgear.cavesandcliffs.common.util.feature.DripstoneHelper;
import com.blackgear.cavesandcliffs.common.world.gen.feature.SmallDripstoneFeatureConfig;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class SmallDripstoneFeature
extends Feature<SmallDripstoneFeatureConfig> {
    public SmallDripstoneFeature(Codec<SmallDripstoneFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, SmallDripstoneFeatureConfig config) {
        if (!DripstoneHelper.canGenerate((IWorld)reader, pos)) {
            return false;
        }
        int placements = MathUtils.nextBetween(rand, 1, config.maxPlacements);
        boolean canGenerate = false;
        for (int i = 0; i < placements; ++i) {
            BlockPos blockPos = SmallDripstoneFeature.randomPos(rand, pos, config);
            if (!SmallDripstoneFeature.generate(reader, rand, blockPos, config)) continue;
            canGenerate = true;
        }
        return canGenerate;
    }

    private static boolean generate(ISeedReader readerIn, Random random, BlockPos pos, SmallDripstoneFeatureConfig config) {
        Direction direction = Direction.func_239631_a_((Random)random);
        Direction verticalDirection = random.nextBoolean() ? Direction.UP : Direction.DOWN;
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (int i = 0; i < config.emptySpaceSearchRadius; ++i) {
            if (!DripstoneHelper.canGenerate((IWorld)readerIn, (BlockPos)mutable)) {
                return false;
            }
            if (SmallDripstoneFeature.generateDripstone(readerIn, random, (BlockPos)mutable, verticalDirection, config)) {
                return true;
            }
            if (SmallDripstoneFeature.generateDripstone(readerIn, random, (BlockPos)mutable, verticalDirection.func_176734_d(), config)) {
                return true;
            }
            mutable.func_189536_c(direction);
        }
        return false;
    }

    private static boolean generateDripstone(ISeedReader readerIn, Random random, BlockPos pos, Direction direction, SmallDripstoneFeatureConfig config) {
        if (!DripstoneHelper.canGenerate((IWorld)readerIn, pos)) {
            return false;
        }
        BlockPos blockPos = pos.func_177972_a(direction.func_176734_d());
        BlockState state = readerIn.func_180495_p(blockPos);
        if (!DripstoneHelper.canReplace(state)) {
            return false;
        }
        SmallDripstoneFeature.generateDripstoneBlocks(readerIn, random, blockPos);
        int height = random.nextFloat() < config.chanceOfTallerDripstone && DripstoneHelper.canGenerate((IWorld)readerIn, pos.func_177972_a(direction)) ? 2 : 1;
        DripstoneHelper.generatePointedDripstone(readerIn, pos, direction, height, false);
        return true;
    }

    private static void generateDripstoneBlocks(ISeedReader readerIn, Random random, BlockPos pos) {
        DripstoneHelper.generateDripstoneBlock(readerIn, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!(random.nextFloat() >= 0.3f)) continue;
            BlockPos blockPos = pos.func_177972_a(direction);
            DripstoneHelper.generateDripstoneBlock(readerIn, blockPos);
            if (random.nextBoolean()) continue;
            BlockPos blockPos1 = blockPos.func_177972_a(Direction.func_239631_a_((Random)random));
            DripstoneHelper.generateDripstoneBlock(readerIn, blockPos1);
            if (random.nextBoolean()) continue;
            BlockPos blockPos2 = blockPos1.func_177972_a(Direction.func_239631_a_((Random)random));
            DripstoneHelper.generateDripstoneBlock(readerIn, blockPos2);
        }
    }

    private static BlockPos randomPos(Random random, BlockPos pos, SmallDripstoneFeatureConfig config) {
        return pos.func_177982_a(MathUtils.nextBetween(random, -config.maxOffsetFromOrigin, config.maxOffsetFromOrigin), MathUtils.nextBetween(random, -config.maxOffsetFromOrigin, config.maxOffsetFromOrigin), MathUtils.nextBetween(random, -config.maxOffsetFromOrigin, config.maxOffsetFromOrigin));
    }
}

