/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.util.feature;

import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;

public class FeatureHelper {
    public static Predicate<BlockState> notInBlockTagPredicate(ResourceLocation tagID) {
        ITag tag = BlockTags.func_199896_a().func_241834_b(tagID);
        return state -> !state.func_235714_a_(tag);
    }

    public static void setBlockStateIf(ISeedReader reader, BlockPos pos, BlockState state, Predicate<BlockState> predicate) {
        if (predicate.test(reader.func_180495_p(pos))) {
            reader.func_180501_a(pos, state, 2);
        }
    }

    public static boolean testAdjacentStates(Function<BlockPos, BlockState> posToState, BlockPos pos, Predicate<BlockState> predicate) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.values()) {
            mutable.func_239622_a_((Vector3i)pos, direction);
            if (!predicate.test(posToState.apply((BlockPos)mutable))) continue;
            return true;
        }
        return false;
    }

    public static boolean isExposedToAir(Function<BlockPos, BlockState> posToState, BlockPos pos) {
        return FeatureHelper.testAdjacentStates(posToState, pos, AbstractBlock.AbstractBlockState::func_196958_f);
    }
}

