/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.events;

import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="cavesandcliffs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RemapEvent {
    @SubscribeEvent
    public static void remapBlocks(RegistryEvent.MissingMappings<Block> event) {
        MappingManager manager = MappingManager.createBlockMaps("cavesandcliffs", event);
        manager.remap("azalea_leaves_flowers", (Block)CCBBlocks.FLOWERING_AZALEA_LEAVES.get());
        manager.remap("waxed_copper", (Block)CCBBlocks.WAXED_COPPER_BLOCK.get());
        manager.remap("cave_vines_head", (Block)CCBBlocks.CAVE_VINES.get());
        manager.remap("cave_vines_body", (Block)CCBBlocks.CAVE_VINES_PLANT.get());
        manager.remap("water_cauldron", Blocks.field_150383_bp);
    }

    @SubscribeEvent
    public static void remapItems(RegistryEvent.MissingMappings<Item> event) {
        MappingManager manager = MappingManager.createItemMaps("cavesandcliffs", event);
        manager.remap("azalea_leaves_flowers", (Block)CCBBlocks.FLOWERING_AZALEA_LEAVES.get());
        manager.remap("waxed_copper", (Block)CCBBlocks.WAXED_COPPER_BLOCK.get());
    }

    private static class MappingManager {
        private final String modId;
        private final RegistryEvent.MissingMappings<Block> mapBlock;
        private final RegistryEvent.MissingMappings<Item> mapItem;

        public static MappingManager createBlockMaps(String modId, RegistryEvent.MissingMappings<Block> mappings) {
            return new MappingManager(modId, mappings, null);
        }

        public static MappingManager createItemMaps(String modId, RegistryEvent.MissingMappings<Item> mappings) {
            return new MappingManager(modId, null, mappings);
        }

        private MappingManager(String modId, RegistryEvent.MissingMappings<Block> mappings, RegistryEvent.MissingMappings<Item> mapItem) {
            this.modId = modId;
            this.mapBlock = mappings;
            this.mapItem = mapItem;
        }

        private void remap(String input, Block output) {
            if (this.mapBlock != null) {
                for (RegistryEvent.MissingMappings.Mapping mapping : this.mapBlock.getAllMappings()) {
                    if (!mapping.key.func_110624_b().equals(this.modId) || !mapping.key.func_110623_a().equals(input)) continue;
                    mapping.remap((IForgeRegistryEntry)output);
                }
            }
            if (this.mapItem != null) {
                for (RegistryEvent.MissingMappings.Mapping mapping : this.mapItem.getAllMappings()) {
                    if (!mapping.key.func_110624_b().equals(this.modId) || !mapping.key.func_110623_a().equals(input)) continue;
                    mapping.remap((IForgeRegistryEntry)output.func_199767_j());
                }
            }
        }
    }
}

