/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity.ai.task;

import com.blackgear.cavesandcliffs.common.util.EntityHelper;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBMemoryModuleTypes;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.potion.Effects;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockPosWrapper;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;

public class LongJumpTask<E extends MobEntity>
extends Task<E> {
    private final RangedInteger cooldownRange;
    private final int verticalRange;
    private final int horizontalRange;
    private final float maxRange;
    private final List<Target> targets = new ArrayList<Target>();
    private Optional<Vector3d> lastPos = Optional.empty();
    private Optional<Target> lastTarget = Optional.empty();
    private int cooldown;
    private long targetTime;
    private final Function<E, SoundEvent> sound;

    public LongJumpTask(RangedInteger cooldownRange, int verticalRange, int horizontalRange, float maxRange, Function<E, SoundEvent> sound) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleStatus.REGISTERED, (Object)CCBMemoryModuleTypes.LONG_JUMP_COOLING_DOWN.get(), (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)CCBMemoryModuleTypes.LONG_JUMP_MID_JUMP.get(), (Object)MemoryModuleStatus.VALUE_ABSENT));
        this.cooldownRange = cooldownRange;
        this.verticalRange = verticalRange;
        this.horizontalRange = horizontalRange;
        this.maxRange = maxRange;
        this.sound = sound;
    }

    protected boolean shouldExecute(ServerWorld worldIn, E owner) {
        return owner.func_233570_aj_() && !worldIn.func_180495_p(owner.func_233580_cy_()).func_203425_a(Blocks.field_226907_mc_);
    }

    protected boolean shouldContinueExecuting(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        boolean shouldContinue;
        boolean bl = shouldContinue = this.lastPos.isPresent() && this.lastPos.get().equals((Object)entityIn.func_213303_ch()) && this.cooldown > 0 && (this.lastTarget.isPresent() || !this.targets.isEmpty());
        if (!shouldContinue && !entityIn.func_213375_cj().func_218207_c((MemoryModuleType)CCBMemoryModuleTypes.LONG_JUMP_MID_JUMP.get()).isPresent()) {
            entityIn.func_213375_cj().func_218205_a((MemoryModuleType)CCBMemoryModuleTypes.LONG_JUMP_COOLING_DOWN.get(), (Object)(this.cooldownRange.func_233018_a_(worldIn.func_201674_k()) / 2));
        }
        return shouldContinue;
    }

    protected void startExecuting(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        this.lastTarget = Optional.empty();
        this.cooldown = 20;
        this.targets.clear();
        this.lastPos = Optional.of(entityIn.func_213303_ch());
        BlockPos pos = entityIn.func_233580_cy_();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        Iterable positions = BlockPos.func_191531_b((int)(x - this.horizontalRange), (int)(y - this.verticalRange), (int)(z - this.horizontalRange), (int)(x + this.horizontalRange), (int)(y + this.verticalRange), (int)(z + this.horizontalRange));
        PathNavigator pathNavigator = entityIn.func_70661_as();
        for (BlockPos blockPos : positions) {
            double distance = blockPos.func_177951_i((Vector3i)pos);
            if (x == blockPos.func_177958_n() && z == blockPos.func_177952_p() || !pathNavigator.func_188555_b(blockPos) || entityIn.func_184643_a(WalkNodeProcessor.func_237231_a_((IBlockReader)((MobEntity)entityIn).field_70170_p, (BlockPos.Mutable)blockPos.func_239590_i_())) != 0.0f) continue;
            Optional<Vector3d> rammingVelocity = this.getRammingVelocity((MobEntity)entityIn, Vector3d.func_237489_a_((Vector3i)blockPos));
            rammingVelocity.ifPresent(vector -> this.targets.add(new Target(new BlockPos((Vector3i)blockPos), (Vector3d)vector, MathHelper.func_76143_f((double)distance))));
        }
    }

    protected void updateTask(ServerWorld worldIn, E owner, long gameTime) {
        if (this.lastTarget.isPresent()) {
            if (gameTime - this.targetTime >= 40L) {
                ((MobEntity)owner).field_70177_z = ((MobEntity)owner).field_70761_aq;
                Vector3d vec3d = this.lastTarget.get().getRammingVelocity();
                double d = vec3d.func_72433_c();
                double e = d + (owner.func_70644_a(Effects.field_76430_j) ? (double)(0.1f * (float)owner.func_70660_b(Effects.field_76430_j).func_76458_c() + 1.0f) : 0.0);
                owner.func_213317_d(vec3d.func_186678_a(e / d));
                owner.func_213375_cj().func_218205_a((MemoryModuleType)CCBMemoryModuleTypes.LONG_JUMP_MID_JUMP.get(), (Object)true);
                worldIn.func_217384_a(null, owner, this.sound.apply(owner), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        } else {
            --this.cooldown;
            Optional<WeightedRandom.Item> optional = Optional.of(WeightedRandom.func_76271_a((Random)worldIn.func_201674_k(), this.targets));
            if (optional.isPresent()) {
                this.targets.remove(optional.get());
                owner.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, (Object)new BlockPosWrapper(((Target)optional.get()).getPos()));
                PathNavigator entityNavigation = owner.func_70661_as();
                Path path = entityNavigation.func_179680_a(((Target)optional.get()).getPos(), 0);
                if (path == null || !path.func_224771_h()) {
                    this.lastTarget = optional;
                    this.targetTime = gameTime;
                }
            }
        }
    }

    private Optional<Vector3d> getRammingVelocity(MobEntity entity, Vector3d pos) {
        Optional<Vector3d> velocity = Optional.empty();
        for (int range = 65; range < 85; range += 5) {
            Optional<Vector3d> rammingVelocity = this.getRammingVelocity(entity, pos, range);
            if (velocity.isPresent() && (!rammingVelocity.isPresent() || !(rammingVelocity.get().func_189985_c() < velocity.get().func_189985_c()))) continue;
            velocity = rammingVelocity;
        }
        return velocity;
    }

    private Optional<Vector3d> getRammingVelocity(MobEntity entity, Vector3d pos, int range) {
        Vector3d vec3d = entity.func_213303_ch();
        Vector3d vec3d2 = new Vector3d(pos.field_72450_a - vec3d.field_72450_a, 0.0, pos.field_72449_c - vec3d.field_72449_c).func_72432_b().func_186678_a(0.5);
        pos = pos.func_178788_d(vec3d2);
        Vector3d vec3d3 = pos.func_178788_d(vec3d);
        float f = (float)range * (float)Math.PI / 180.0f;
        double d = Math.atan2(vec3d3.field_72449_c, vec3d3.field_72450_a);
        double e = vec3d3.func_178786_a(0.0, vec3d3.field_72448_b, 0.0).func_189985_c();
        double g = Math.sqrt(e);
        double h = vec3d3.field_72448_b;
        double i = Math.sin(2.0f * f);
        double k = Math.pow(Math.cos(f), 2.0);
        double l = Math.sin(f);
        double m = Math.cos(f);
        double n = Math.sin(d);
        double o = Math.cos(d);
        double p = e * 0.8 / (g * i - 2.0 * h * k);
        if (p < 0.0) {
            return Optional.empty();
        }
        double rangeIn = Math.sqrt(p);
        if (rangeIn > (double)this.maxRange) {
            return Optional.empty();
        }
        double r = rangeIn * m;
        double s = rangeIn * l;
        int t = MathHelper.func_76143_f((double)(g / r)) * 2;
        double u = 0.0;
        Vector3d startPos = null;
        for (int v = 0; v < t - 1; ++v) {
            double w = l / m * (u += g / (double)t) - Math.pow(u, 2.0) * 0.08 / (2.0 * p * Math.pow(m, 2.0));
            double x = u * o;
            double y = u * n;
            Vector3d endPos = new Vector3d(vec3d.field_72450_a + x, vec3d.field_72448_b + w, vec3d.field_72449_c + y);
            if (startPos != null && !this.canReach(entity, startPos, endPos)) {
                return Optional.empty();
            }
            startPos = endPos;
        }
        return Optional.of(new Vector3d(r * o, s, r * n).func_186678_a((double)0.95f));
    }

    private boolean canReach(MobEntity entity, Vector3d startPos, Vector3d endPos) {
        EntitySize entityDimensions = entity.func_213305_a(EntityHelper.LONG_JUMPING);
        Vector3d vec3d = endPos.func_178788_d(startPos);
        double d = Math.min(entityDimensions.field_220315_a, entityDimensions.field_220316_b);
        int i = MathHelper.func_76143_f((double)(vec3d.func_72433_c() / d));
        Vector3d vec3d2 = vec3d.func_72432_b();
        Vector3d vec3d3 = startPos;
        for (int j = 0; j < i; ++j) {
            vec3d3 = j == i - 1 ? endPos : vec3d3.func_178787_e(vec3d2.func_186678_a(d * (double)0.9f));
            AxisAlignedBB box = entityDimensions.func_242286_a(vec3d3);
            if (entity.field_70170_p.func_226665_a__((Entity)entity, box)) continue;
            return false;
        }
        return true;
    }

    public static class Target
    extends WeightedRandom.Item {
        private final BlockPos pos;
        private final Vector3d ramVelocity;

        public Target(BlockPos pos, Vector3d ramVelocity, int itemWeightIn) {
            super(itemWeightIn);
            this.pos = pos;
            this.ramVelocity = ramVelocity;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Vector3d getRammingVelocity() {
            return this.ramVelocity;
        }
    }
}

