/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity;

import com.blackgear.cavesandcliffs.common.entity.GoatTasks;
import com.blackgear.cavesandcliffs.common.item.ItemUsage;
import com.blackgear.cavesandcliffs.common.math.MathUtils;
import com.blackgear.cavesandcliffs.common.util.EntityHelper;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBEntityTypes;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBMemoryModuleTypes;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBSensorTypes;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GoatEntity
extends AnimalEntity {
    public static final EntitySize LONG_JUMPING_DIMENSIONS = EntitySize.func_220314_b((float)0.9f, (float)1.3f).func_220313_a(0.7f);
    protected static final ImmutableList<SensorType<? extends Sensor<? super GoatEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.field_220998_b, (Object)SensorType.field_220999_c, (Object)SensorType.field_234129_b_, (Object)SensorType.field_234132_n_, (Object)SensorType.field_221002_f, (Object)CCBSensorTypes.GOAT_TEMPTATIONS.get());
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_MODULES = ImmutableList.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleType.field_223021_x, (Object)MemoryModuleType.field_220954_o, (Object)MemoryModuleType.field_234097_ae_, (Object)MemoryModuleType.field_220953_n, (Object)CCBMemoryModuleTypes.LONG_JUMP_COOLING_DOWN.get(), (Object)CCBMemoryModuleTypes.LONG_JUMP_MID_JUMP.get(), (Object)CCBMemoryModuleTypes.TEMPTING_PLAYER.get(), (Object)MemoryModuleType.field_234075_I_, (Object)CCBMemoryModuleTypes.TEMPTATION_COOLDOWN_TICKS.get(), (Object[])new MemoryModuleType[]{(MemoryModuleType)CCBMemoryModuleTypes.IS_TEMPTED.get(), (MemoryModuleType)CCBMemoryModuleTypes.RAM_COOLDOWN_TICKS.get(), (MemoryModuleType)CCBMemoryModuleTypes.RAM_TARGET.get()});
    private static final DataParameter<Boolean> SCREAMING = EntityDataManager.func_187226_a(GoatEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private boolean preparingRam;
    private int rammingTicks;

    public GoatEntity(EntityType<? extends GoatEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_70661_as().func_212239_d(true);
    }

    protected Brain.BrainCodec<GoatEntity> func_230289_cH_() {
        return Brain.func_233705_a_(MEMORY_MODULES, SENSOR_TYPES);
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamicIn) {
        return GoatTasks.makeBrain((Brain<GoatEntity>)this.func_230289_cH_().func_233748_a_(dynamicIn));
    }

    public static AttributeModifierMap.MutableAttribute createGoatAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233819_b_, 8.0);
    }

    protected void func_175500_n() {
        if (this.func_70631_g_()) {
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(1.0);
        } else {
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(2.0);
        }
    }

    protected int func_225508_e_(float distance, float damageMultiplier) {
        return super.func_225508_e_(distance, damageMultiplier) - 10;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_SCREAMING_AMBIENT.get() : (SoundEvent)CCBSoundEvents.ENTITY_GOAT_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_SCREAMING_HURT.get() : (SoundEvent)CCBSoundEvents.ENTITY_GOAT_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return this.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_SCREAMING_DEATH.get() : (SoundEvent)CCBSoundEvents.ENTITY_GOAT_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a((SoundEvent)CCBSoundEvents.ENTITY_GOAT_STEP.get(), 0.15f, 1.0f);
    }

    protected SoundEvent getMilkingSound() {
        return this.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_SCREAMING_MILK.get() : (SoundEvent)CCBSoundEvents.ENTITY_GOAT_MILK.get();
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity entity) {
        GoatEntity goat = (GoatEntity)((EntityType)CCBEntityTypes.GOAT.get()).func_200721_a((World)world);
        if (goat != null) {
            GoatTasks.resetLongJumpCooldown(goat);
            boolean isScreamingGoat = entity instanceof GoatEntity && ((GoatEntity)entity).isScreaming();
            goat.setScreaming(isScreamingGoat || world.func_201674_k().nextDouble() < 0.02);
        }
        return goat;
    }

    public Brain<GoatEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("goatBrain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, (LivingEntity)this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("goatActivityUpdate");
        GoatTasks.updateActivities(this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        super.func_70619_bc();
    }

    public int func_184649_cE() {
        return 15;
    }

    public void func_70034_d(float rotation) {
        int horizontalFaceSpeed = this.func_184649_cE();
        float angleRotation = MathHelper.func_203302_c((float)this.field_70761_aq, (float)rotation);
        float yawRotation = MathHelper.func_76131_a((float)angleRotation, (float)(-horizontalFaceSpeed), (float)horizontalFaceSpeed);
        super.func_70034_d(this.field_70761_aq + yawRotation);
    }

    public SoundEvent func_213353_d(ItemStack itemStackIn) {
        return this.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_SCREAMING_EAT.get() : (SoundEvent)CCBSoundEvents.ENTITY_GOAT_EAT.get();
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b().equals(Items.field_151133_ar) && !this.func_70631_g_()) {
            player.func_184185_a(this.getMilkingSound(), 1.0f, 1.0f);
            ItemStack filledBucket = ItemUsage.exchangeStack(stack, player, Items.field_151117_aB.func_190903_i());
            player.func_184611_a(hand, filledBucket);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
        }
        ActionResultType actionResultType = super.func_230254_b_(player, hand);
        if (actionResultType.func_226247_b_() && this.func_70877_b(stack)) {
            this.field_70170_p.func_217384_a(null, (Entity)this, this.func_213353_d(stack), SoundCategory.NEUTRAL, 1.0f, MathUtils.nextBetween(this.field_70170_p.func_201674_k(), 0.8f, 1.2f));
        }
        return actionResultType;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        GoatTasks.resetLongJumpCooldown(this);
        this.setScreaming(worldIn.func_201674_k().nextDouble() < 0.02);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_213387_K() {
        super.func_213387_K();
        DebugPacketSender.func_218798_a((LivingEntity)this);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return poseIn == EntityHelper.LONG_JUMPING ? LONG_JUMPING_DIMENSIONS.func_220313_a(this.func_213355_cm()) : super.func_213305_a(poseIn);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsScreamingGoat", this.isScreaming());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setScreaming(compound.func_74767_n("IsScreamingGoat"));
    }

    public void func_70103_a(byte id) {
        if (id == 58) {
            this.preparingRam = true;
        } else if (id == 59) {
            this.preparingRam = false;
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70636_d() {
        this.rammingTicks = this.preparingRam ? ++this.rammingTicks : (this.rammingTicks -= 2);
        this.rammingTicks = MathHelper.func_76125_a((int)this.rammingTicks, (int)0, (int)20);
        super.func_70636_d();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SCREAMING, (Object)false);
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAMING);
    }

    public void setScreaming(boolean screaming) {
        this.field_70180_af.func_187227_b(SCREAMING, (Object)screaming);
    }

    public float getHeadPitch() {
        return (float)this.rammingTicks / 20.0f * 30.0f * 0.02f;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new GoatPathNavigator((MobEntity)this, worldIn);
    }

    public static boolean canSpawn(EntityType<? extends AnimalEntity> entityType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random rand) {
        BlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return (state.func_203425_a(Blocks.field_150348_b) || state.func_203425_a(Blocks.field_150433_aE) || state.func_203425_a((Block)CCBBlocks.POWDER_SNOW.get()) || state.func_203425_a(Blocks.field_196604_cC) || state.func_203425_a(Blocks.field_150403_cj) || state.func_203425_a(Blocks.field_150351_n)) && worldIn.func_226659_b_(pos, 0) > 8;
    }

    private static class GoatPathNodeProcessor
    extends WalkNodeProcessor {
        private final BlockPos.Mutable pos = new BlockPos.Mutable();

        private GoatPathNodeProcessor() {
        }

        public PathNodeType func_186330_a(IBlockReader reader, int x, int y, int z) {
            this.pos.func_181079_c(x, y - 1, z);
            BlockState state = reader.func_180495_p((BlockPos)this.pos);
            return state.func_203425_a((Block)CCBBlocks.POWDER_SNOW.get()) ? PathNodeType.BLOCKED : GoatPathNodeProcessor.func_237231_a_((IBlockReader)reader, (BlockPos.Mutable)this.pos.func_189536_c(Direction.UP));
        }
    }

    private static class GoatPathNavigator
    extends GroundPathNavigator {
        public GoatPathNavigator(MobEntity entityIn, World worldIn) {
            super(entityIn, worldIn);
        }

        protected PathFinder func_179679_a(int range) {
            this.field_179695_a = new GoatPathNodeProcessor();
            return new PathFinder(this.field_179695_a, range);
        }
    }
}

