/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.AmethystBlock;
import com.blackgear.cavesandcliffs.common.blocks.ILandingBlock;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class AmethystClusterBlock
extends AmethystBlock
implements IWaterLoggable,
ILandingBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    protected final VoxelShape NORTH_SHAPE;
    protected final VoxelShape SOUTH_SHAPE;
    protected final VoxelShape EAST_SHAPE;
    protected final VoxelShape WEST_SHAPE;
    protected final VoxelShape UP_SHAPE;
    protected final VoxelShape DOWN_SHAPE;

    public AmethystClusterBlock(int height, int xzOffset, AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.UP));
        this.UP_SHAPE = Block.func_208617_a((double)xzOffset, (double)0.0, (double)xzOffset, (double)(16 - xzOffset), (double)height, (double)(16 - xzOffset));
        this.DOWN_SHAPE = Block.func_208617_a((double)xzOffset, (double)(16 - height), (double)xzOffset, (double)(16 - xzOffset), (double)16.0, (double)(16 - xzOffset));
        this.NORTH_SHAPE = Block.func_208617_a((double)xzOffset, (double)xzOffset, (double)(16 - height), (double)(16 - xzOffset), (double)(16 - xzOffset), (double)16.0);
        this.SOUTH_SHAPE = Block.func_208617_a((double)xzOffset, (double)xzOffset, (double)0.0, (double)(16 - xzOffset), (double)(16 - xzOffset), (double)height);
        this.EAST_SHAPE = Block.func_208617_a((double)0.0, (double)xzOffset, (double)xzOffset, (double)height, (double)(16 - xzOffset), (double)(16 - xzOffset));
        this.WEST_SHAPE = Block.func_208617_a((double)(16 - height), (double)xzOffset, (double)xzOffset, (double)16.0, (double)(16 - xzOffset), (double)(16 - xzOffset));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        switch (direction) {
            case NORTH: {
                return this.NORTH_SHAPE;
            }
            case SOUTH: {
                return this.SOUTH_SHAPE;
            }
            case EAST: {
                return this.EAST_SHAPE;
            }
            case WEST: {
                return this.WEST_SHAPE;
            }
            case DOWN: {
                return this.DOWN_SHAPE;
            }
        }
        return this.UP_SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockPos blockPos = pos.func_177972_a(direction.func_176734_d());
        return worldIn.func_180495_p(blockPos).func_224755_d((IBlockReader)worldIn, blockPos, direction);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing == ((Direction)stateIn.func_177229_b((Property)FACING)).func_176734_d() && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World worldReader = context.func_195991_k();
        BlockPos blockPos = context.func_195995_a();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldReader.func_204610_c(blockPos).func_206886_c() == Fluids.field_204546_a))).func_206870_a((Property)FACING, (Comparable)context.func_196000_l());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, FACING});
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }
}

