/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common;

import com.blackgear.cavesandcliffs.core.CavesAndCliffsConfig;
import com.blackgear.cavesandcliffs.core.other.tags.CCBItemTags;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class RawOreLootModifier
extends LootModifier {
    public RawOreLootModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (!((Boolean)CavesAndCliffsConfig.RAW_ORE_DROPS.get()).booleanValue()) {
            return generatedLoot;
        }
        Random random = new Random();
        ItemStack ctxTool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (generatedLoot.size() == 0) {
            return generatedLoot;
        }
        ArrayList<ItemStack> returnable = this.checkLoot(generatedLoot);
        if (generatedLoot.get(0).func_77973_b() == returnable.get(0).func_77973_b() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)Objects.requireNonNull(ctxTool)) != 0) {
            return generatedLoot;
        }
        int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)ctxTool);
        ArrayList<ItemStack> rawOre = new ArrayList<ItemStack>();
        int size = RawOreLootModifier.generatedSize(generatedLoot);
        rawOre.add(new ItemStack((IItemProvider)returnable.get(0).func_77973_b(), size + random.nextInt(1 + enchantmentLevel)));
        return rawOre;
    }

    private static int generatedSize(List<ItemStack> generatedLoot) {
        Item ore = generatedLoot.get(0).func_77973_b();
        int size = ore.func_206844_a(CCBItemTags.ORES_COPPER) ? MathHelper.func_76136_a((Random)new Random(), (int)2, (int)5) : generatedLoot.size();
        return size;
    }

    private static ArrayList<ItemStack> getRawOre(String ore) {
        ArrayList<ItemStack> returnable = new ArrayList<ItemStack>();
        Item rawOre = RawOreLootModifier.getRawOreItem(ore);
        returnable.add(new ItemStack((IItemProvider)rawOre));
        return returnable;
    }

    private ArrayList<ItemStack> checkLoot(List<ItemStack> generatedLoot) {
        Item rawOre = generatedLoot.get(0).func_77973_b();
        if (rawOre.func_206844_a((ITag)Tags.Items.ORES_IRON)) {
            return RawOreLootModifier.getRawOre("iron");
        }
        if (rawOre.func_206844_a((ITag)Tags.Items.ORES_GOLD)) {
            return RawOreLootModifier.getRawOre("gold");
        }
        if (rawOre.func_206844_a(CCBItemTags.ORES_COPPER)) {
            if (((Boolean)CavesAndCliffsConfig.RAW_ORE_FOR_EXTERNAL_COPPER.get()).booleanValue()) {
                return RawOreLootModifier.getRawOre("copper");
            }
            if (rawOre == ((Block)CCBBlocks.COPPER_ORE.get()).func_199767_j() || rawOre == ((Block)CCBBlocks.DEEPSLATE_COPPER_ORE.get()).func_199767_j()) {
                return RawOreLootModifier.getRawOre("copper");
            }
        }
        return (ArrayList)generatedLoot;
    }

    private static Item getRawOreItem(String ore) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("cavesandcliffs", "raw_" + ore));
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<RawOreLootModifier> {
        public RawOreLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            return new RawOreLootModifier(conditions);
        }

        public JsonObject write(RawOreLootModifier instance) {
            return new JsonObject();
        }
    }
}

