/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.client.particle;

import com.blackgear.cavesandcliffs.common.math.MathUtils;
import com.blackgear.cavesandcliffs.core.registries.CCBParticleTypes;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DrippingParticle
extends SpriteTexturedParticle {
    private final Fluid fluid;

    protected DrippingParticle(ClientWorld world, double x, double y, double z, Fluid fluid) {
        super(world, x, y, z);
        this.func_187115_a(0.01f, 0.01f);
        this.field_70545_g = 0.06f;
        this.fluid = fluid;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.updateAge();
        if (!this.field_187133_m) {
            this.field_187130_j -= (double)this.field_70545_g;
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.updateVelocity();
            if (!this.field_187133_m) {
                this.field_187129_i *= 1.0;
                this.field_187130_j *= 1.0;
                this.field_187131_k *= 1.0;
                BlockPos blockPos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
                FluidState fluidState = this.field_187122_b.func_204610_c(blockPos);
                if (fluidState.func_206886_c() == this.fluid && this.field_187127_g < (double)((float)blockPos.func_177956_o() + fluidState.func_215679_a((IBlockReader)this.field_187122_b, blockPos))) {
                    this.func_187112_i();
                }
            }
        }
    }

    protected void updateAge() {
        if (this.field_70547_e-- <= 0) {
            this.func_187112_i();
        }
    }

    protected void updateVelocity() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FallingSporeBlossomFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite animatedSprite;
        private final Random random;

        public FallingSporeBlossomFactory(IAnimatedSprite animatedSprite) {
            this.animatedSprite = animatedSprite;
            this.random = new Random();
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            int maxAge = (int)(64.0f / MathUtils.nextBetween(this.random, 0.1f, 0.9f));
            Falling drippingParticle = new Falling(worldIn, x, y, z, Fluids.field_204541_a, maxAge);
            ((DrippingParticle)drippingParticle).field_70545_g = 0.005f;
            drippingParticle.func_70538_b(0.32f, 0.5f, 0.22f);
            drippingParticle.func_217568_a(this.animatedSprite);
            return drippingParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FallingDripstoneWaterFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite animatedSprite;

        public FallingDripstoneWaterFactory(IAnimatedSprite animatedSprite) {
            this.animatedSprite = animatedSprite;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Dripping drippingParticle = new Dripping(worldIn, x, y, z, (Fluid)Fluids.field_204546_a, (IParticleData)CCBParticleTypes.FALLING_DRIPSTONE_WATER.get());
            drippingParticle.func_70538_b(0.2f, 0.3f, 1.0f);
            drippingParticle.func_217568_a(this.animatedSprite);
            return drippingParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LandingDripstoneWaterFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite animatedSprite;

        public LandingDripstoneWaterFactory(IAnimatedSprite animatedSprite) {
            this.animatedSprite = animatedSprite;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DripstoneLavaDrip drippingParticle = new DripstoneLavaDrip(worldIn, x, y, z, (Fluid)Fluids.field_204546_a, (IParticleData)ParticleTypes.field_218422_X);
            drippingParticle.func_70538_b(0.2f, 0.3f, 1.0f);
            drippingParticle.func_217568_a(this.animatedSprite);
            return drippingParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FallingDripstoneLavaFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite animatedSprite;

        public FallingDripstoneLavaFactory(IAnimatedSprite animatedSprite) {
            this.animatedSprite = animatedSprite;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DrippingLava drippingParticle = new DrippingLava(worldIn, x, y, z, (Fluid)Fluids.field_204547_b, (IParticleData)CCBParticleTypes.FALLING_DRIPSTONE_LAVA.get());
            drippingParticle.func_217568_a(this.animatedSprite);
            return drippingParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LandingDripstoneLavaFactory
    implements IParticleFactory<BasicParticleType> {
        protected final IAnimatedSprite animatedSprite;

        public LandingDripstoneLavaFactory(IAnimatedSprite animatedSprite) {
            this.animatedSprite = animatedSprite;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DripstoneLavaDrip drippingParticle = new DripstoneLavaDrip(worldIn, x, y, z, (Fluid)Fluids.field_204547_b, (IParticleData)ParticleTypes.field_218424_l);
            drippingParticle.func_70538_b(1.0f, 0.2857143f, 0.083333336f);
            drippingParticle.func_217568_a(this.animatedSprite);
            return drippingParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class DripstoneLavaDrip
    extends ContinuousFalling {
        DripstoneLavaDrip(ClientWorld world, double x, double y, double z, Fluid fluid, IParticleData nextParticle) {
            super(world, x, y, z, fluid, nextParticle);
        }

        @Override
        protected void updateVelocity() {
            if (this.field_187132_l) {
                this.func_187112_i();
                this.field_187122_b.func_195594_a(this.nextParticle, this.field_187126_f, this.field_187127_g, this.field_187128_h, 0.0, 0.0, 0.0);
                SoundEvent soundEvent = this.getFluid() == Fluids.field_204547_b ? (SoundEvent)CCBSoundEvents.BLOCK_POINTED_DRIPSTONE_DRIP_LAVA.get() : (SoundEvent)CCBSoundEvents.BLOCK_POINTED_DRIPSTONE_DRIP_WATER.get();
                float volume = MathUtils.nextBetween(this.field_187136_p, 0.3f, 1.0f);
                this.field_187122_b.func_184134_a(this.field_187126_f, this.field_187127_g, this.field_187128_h, soundEvent, SoundCategory.BLOCKS, volume, 1.0f, false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class DrippingLava
    extends Dripping {
        DrippingLava(ClientWorld clientWorld, double d, double e, double f, Fluid fluid, IParticleData particleEffect) {
            super(clientWorld, d, e, f, fluid, particleEffect);
        }

        @Override
        protected void updateAge() {
            this.field_70552_h = 1.0f;
            this.field_70553_i = 16.0f / (float)(40 - this.field_70547_e + 16);
            this.field_70551_j = 4.0f / (float)(40 - this.field_70547_e + 8);
            super.updateAge();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Dripping
    extends DrippingParticle {
        protected final IParticleData nextParticle;

        Dripping(ClientWorld world, double x, double y, double z, Fluid fluid, IParticleData nextParticle) {
            super(world, x, y, z, fluid);
            this.nextParticle = nextParticle;
            this.field_70545_g *= 0.02f;
            this.field_70547_e = 40;
        }

        @Override
        protected void updateAge() {
            if (this.field_70547_e-- <= 0) {
                this.func_187112_i();
                this.field_187122_b.func_195594_a(this.nextParticle, this.field_187126_f, this.field_187127_g, this.field_187128_h, this.field_187129_i, this.field_187130_j, this.field_187131_k);
            }
        }

        @Override
        protected void updateVelocity() {
            this.field_187129_i *= 0.02;
            this.field_187130_j *= 0.02;
            this.field_187131_k *= 0.02;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ContinuousFalling
    extends Falling {
        protected final IParticleData nextParticle;

        ContinuousFalling(ClientWorld world, double x, double y, double z, Fluid fluid, IParticleData nextParticle) {
            super(world, x, y, z, fluid);
            this.nextParticle = nextParticle;
        }

        @Override
        protected void updateVelocity() {
            if (this.field_187132_l) {
                this.func_187112_i();
                this.field_187122_b.func_195594_a(this.nextParticle, this.field_187126_f, this.field_187127_g, this.field_187128_h, 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Falling
    extends DrippingParticle {
        Falling(ClientWorld world, double x, double y, double z, Fluid fluid) {
            this(world, x, y, z, fluid, (int)(64.0 / (Math.random() * 0.8 + 0.2)));
        }

        Falling(ClientWorld world, double x, double y, double z, Fluid fluid, int maxAge) {
            super(world, x, y, z, fluid);
            this.field_70547_e = maxAge;
        }

        @Override
        protected void updateVelocity() {
            if (this.field_187132_l) {
                this.func_187112_i();
            }
        }
    }
}

