/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.world.structure.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.izofar.bygonenether.init.ModBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.BasaltColumnFeature;
import net.minecraft.world.gen.feature.structure.BasaltDeltasStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public abstract class ModStructureUtils {
    private static final Predicate<Block> isAir = block -> block == Blocks.field_150350_a || block == Blocks.field_201941_jj;

    public static boolean isLavaLake(ChunkGenerator chunkGenerator, int x, int z) {
        IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(x, z);
        BlockPos.Mutable currentPos = new BlockPos.Mutable(x, 31, z);
        boolean isLake = true;
        if (columnOfBlocks.func_180495_p((BlockPos)currentPos).func_177230_c() != Blocks.field_150353_l) {
            isLake = false;
        } else {
            while (currentPos.func_177956_o() < 70) {
                currentPos.func_189536_c(Direction.UP);
                isLake = isLake && isAir.test(columnOfBlocks.func_180495_p((BlockPos)currentPos).func_177230_c());
            }
        }
        return isLake;
    }

    public static boolean isBuried(ChunkGenerator chunkGenerator, int x, int z, int min, int max) {
        IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(x, z);
        BlockPos.Mutable currentPos = new BlockPos.Mutable(x, min, z);
        boolean found = false;
        while (currentPos.func_177956_o() < max) {
            if (isAir.test(columnOfBlocks.func_180495_p(currentPos.func_177984_a()).func_177230_c()) && !isAir.test(columnOfBlocks.func_180495_p((BlockPos)currentPos).func_177230_c())) {
                found = true;
            }
            currentPos.func_189536_c(Direction.UP);
        }
        return !found;
    }

    public static boolean verticalSpace(ChunkGenerator chunkGenerator, int x, int z, int min, int max, int height) {
        IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(x, z);
        BlockPos.Mutable currentPos = new BlockPos.Mutable(x, max, z);
        int height_tracked = 0;
        while (currentPos.func_177956_o() >= min && height_tracked < height) {
            height_tracked = isAir.test(columnOfBlocks.func_180495_p((BlockPos)currentPos).func_177230_c()) ? ++height_tracked : 0;
            currentPos.func_189536_c(Direction.DOWN);
        }
        return height_tracked == height;
    }

    public static BlockPos getElevation(ChunkGenerator chunkGenerator, int x, int z, int min, int max) {
        IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(x, z);
        BlockPos.Mutable currentPos = new BlockPos.Mutable(x, min, z);
        BlockPos blockpos = new BlockPos(x, 0, z);
        boolean found = false;
        while (currentPos.func_177956_o() < max) {
            if (isAir.test(columnOfBlocks.func_180495_p(currentPos.func_177984_a()).func_177230_c()) && !isAir.test(columnOfBlocks.func_180495_p((BlockPos)currentPos).func_177230_c())) {
                blockpos = new BlockPos(blockpos.func_177958_n(), currentPos.func_177956_o(), blockpos.func_177952_p());
                found = true;
            }
            currentPos.func_189536_c(Direction.UP);
        }
        if (!found) {
            blockpos = new BlockPos(blockpos.func_177958_n(), (max + min) / 2, blockpos.func_177952_p());
        }
        return blockpos;
    }

    public static int getFirstLandYFromPos(IWorldReader worldView, BlockPos pos) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        mutable.func_189533_g((Vector3i)pos);
        IChunk currentChunk = worldView.func_217349_x((BlockPos)mutable);
        BlockState currentState = currentChunk.func_180495_p((BlockPos)mutable);
        while (mutable.func_177956_o() >= 0 && ModStructureUtils.isReplaceableByStructures(currentState)) {
            mutable.func_189536_c(Direction.DOWN);
            currentState = currentChunk.func_180495_p((BlockPos)mutable);
        }
        return mutable.func_177956_o();
    }

    private static boolean isReplaceableByStructures(BlockState blockState) {
        return isAir.test(blockState.func_177230_c()) || blockState.func_185904_a().func_76224_d() || blockState.func_185904_a().func_76222_j();
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }

    public static void addBasaltRestrictions() {
        BasaltColumnFeature.field_236245_a_ = ImmutableList.of((Object)Blocks.field_150353_l, (Object)Blocks.field_150357_h, (Object)Blocks.field_196814_hQ, (Object)Blocks.field_150425_aM, (Object)Blocks.field_196653_dH, (Object)Blocks.field_150386_bk, (Object)Blocks.field_150387_bl, (Object)Blocks.field_150388_bm, (Object)Blocks.field_150486_ae, (Object)Blocks.field_150474_ac, (Object)Blocks.field_196575_bC, (Object)Blocks.field_235394_nH_, (Object[])new Block[]{Blocks.field_235393_nG_, Blocks.field_196817_hS, Blocks.field_222443_lg, Blocks.field_222456_lt, Blocks.field_235352_mK_, (Block)ModBlocks.COBBLED_BLACKSTONE.get(), (Block)ModBlocks.WITHERED_BLACKSTONE.get(), (Block)ModBlocks.CHISELED_WITHERED_BLACKSTONE.get(), (Block)ModBlocks.CRACKED_WITHERED_BLACKSTONE.get(), (Block)ModBlocks.WITHERED_DEBRIS.get(), Blocks.field_150411_aY, Blocks.field_150402_ci});
        BasaltDeltasStructure.field_236274_a_ = ImmutableList.of((Object)Blocks.field_150357_h, (Object)Blocks.field_196653_dH, (Object)Blocks.field_150386_bk, (Object)Blocks.field_150387_bl, (Object)Blocks.field_150388_bm, (Object)Blocks.field_150486_ae, (Object)Blocks.field_150474_ac, (Object)Blocks.field_196575_bC, (Object)Blocks.field_235394_nH_, (Object)Blocks.field_235393_nG_, (Object)Blocks.field_196817_hS, (Object)Blocks.field_222443_lg, (Object[])new Block[]{Blocks.field_222456_lt, Blocks.field_235352_mK_, (Block)ModBlocks.COBBLED_BLACKSTONE.get(), (Block)ModBlocks.WITHERED_BLACKSTONE.get(), (Block)ModBlocks.CHISELED_WITHERED_BLACKSTONE.get(), (Block)ModBlocks.CRACKED_WITHERED_BLACKSTONE.get(), (Block)ModBlocks.WITHERED_DEBRIS.get(), Blocks.field_150411_aY, Blocks.field_150402_ci});
    }
}

