/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.world.feature;

import com.izofar.bygonenether.util.random.WeightedEntry;
import com.izofar.bygonenether.util.random.WeightedRandomList;
import com.mojang.datafixers.util.Pair;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class MobPassengerFeature<P extends MobEntity, V extends MobEntity>
extends Feature<NoFeatureConfig> {
    private final WeightedRandomList<Pair<Supplier<EntityType<? extends P>>, Supplier<EntityType<? extends V>>>> entityTypes;

    public MobPassengerFeature(Supplier<EntityType<? extends P>> passenger, Supplier<EntityType<? extends V>> vehicle) {
        super(NoFeatureConfig.field_236558_a_);
        this.entityTypes = WeightedRandomList.create(WeightedEntry.of(Pair.of(passenger, vehicle), 1));
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        Pair<Supplier<EntityType<? extends P>>, Supplier<EntityType<? extends V>>> pair = this.entityTypes.getRandom(world.func_201674_k());
        P passenger = this.createPassenger(world, position, (EntityType)((Supplier)pair.getFirst()).get());
        V vehicle = this.createVehicle(world, position, (EntityType)((Supplier)pair.getSecond()).get());
        passenger.func_184220_m(vehicle);
        world.func_242417_l(vehicle);
        return true;
    }

    private V createVehicle(ISeedReader world, BlockPos position, EntityType<? extends V> vehicleType) {
        MobEntity vehicle = (MobEntity)vehicleType.func_200721_a((World)world.func_201672_e());
        vehicle.func_213386_a((IServerWorld)world, world.func_175649_E(position), SpawnReason.SPAWNER, null, null);
        vehicle.func_70107_b((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p());
        vehicle.func_110163_bv();
        return (V)vehicle;
    }

    private P createPassenger(ISeedReader world, BlockPos position, EntityType<? extends P> passengerType) {
        MobEntity passenger = (MobEntity)passengerType.func_200721_a((World)world.func_201672_e());
        passenger.func_213386_a((IServerWorld)world, world.func_175649_E(position), SpawnReason.SPAWNER, null, null);
        passenger.func_70107_b((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p());
        passenger.func_110163_bv();
        return (P)passenger;
    }
}

