/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.entity;

import com.google.common.collect.ImmutableList;
import com.izofar.bygonenether.entity.ai.PiglinPrisonerAi;
import com.izofar.bygonenether.init.ModMemoryModuleTypes;
import com.izofar.bygonenether.init.ModSensorTypes;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinAction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class PiglinPrisonerEntity
extends AbstractPiglinEntity
implements ICrossbowUser {
    private static final DataParameter<Boolean> DATA_IS_CHARGING_CROSSBOW = EntityDataManager.func_187226_a(PiglinPrisonerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DATA_IS_DANCING = EntityDataManager.func_187226_a(PiglinPrisonerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<UUID>> DATA_OWNERUUID_ID = EntityDataManager.func_187226_a(PiglinPrisonerEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private final Inventory inventory = new Inventory(8);
    protected static final ImmutableList<SensorType<? extends Sensor<? super PiglinPrisonerEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.field_220998_b, (Object)SensorType.field_220999_c, (Object)SensorType.field_234129_b_, (Object)SensorType.field_221002_f, (Object)ModSensorTypes.PIGLIN_PRISONER_SPECIFIC_SENSOR.get());
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.field_220951_l, (Object)MemoryModuleType.field_225462_q, (Object)MemoryModuleType.field_220945_f, (Object)MemoryModuleType.field_220946_g, (Object)MemoryModuleType.field_220949_j, (Object)MemoryModuleType.field_234090_X_, (Object)MemoryModuleType.field_234089_W_, (Object)MemoryModuleType.field_234076_J_, (Object)MemoryModuleType.field_220957_r, (Object)MemoryModuleType.field_220958_s, (Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleType.field_223021_x, (Object[])new MemoryModuleType[]{MemoryModuleType.field_234103_o_, MemoryModuleType.field_234104_p_, MemoryModuleType.field_220952_m, MemoryModuleType.field_220954_o, MemoryModuleType.field_234078_L_, MemoryModuleType.field_234106_z_, MemoryModuleType.field_234080_N_, MemoryModuleType.field_242310_O, MemoryModuleType.field_234081_O_, MemoryModuleType.field_242311_P, MemoryModuleType.field_234083_Q_, MemoryModuleType.field_234084_R_, MemoryModuleType.field_234077_K_, MemoryModuleType.field_234093_aa_, MemoryModuleType.field_234094_ab_, MemoryModuleType.field_234096_ad_, MemoryModuleType.field_234098_af_, (MemoryModuleType)ModMemoryModuleTypes.TEMPTING_PLAYER.get(), (MemoryModuleType)ModMemoryModuleTypes.IS_TEMPTED.get()});

    public PiglinPrisonerEntity(EntityType<? extends AbstractPiglinEntity> entitytype, World world) {
        super(entitytype, world);
        this.field_70728_aV = 5;
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_218657_a("Inventory", (INBT)this.inventory.func_70487_g());
        if (this.getTempterUUID() != null) {
            tag.func_186854_a("Tempter", this.getTempterUUID());
        }
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.inventory.func_70486_a(tag.func_150295_c("Inventory", 10));
        if (tag.func_186855_b("Tempter")) {
            UUID uuid = tag.func_186857_a("Tempter");
            this.setTempterUUID(uuid);
            PiglinPrisonerAi.reloadAllegiance(this, this.getTempter());
        }
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHit) {
        super.func_213333_a(source, looting, recentlyHit);
        this.inventory.func_233543_f_().forEach(arg_0 -> ((PiglinPrisonerEntity)this).func_199701_a_(arg_0));
    }

    public void addToInventory(ItemStack pStack) {
        this.inventory.func_174894_a(pStack);
    }

    public boolean canAddToInventory(ItemStack pStack) {
        return this.inventory.func_233541_b_(pStack);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_IS_CHARGING_CROSSBOW, (Object)false);
        this.field_70180_af.func_187214_a(DATA_IS_DANCING, (Object)false);
        this.field_70180_af.func_187214_a(DATA_OWNERUUID_ID, Optional.empty());
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233821_d_, (double)0.35f).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    protected boolean func_225511_J_() {
        return false;
    }

    public boolean func_213397_c(double pDistanceToClosestPlayer) {
        return !this.func_104002_bU();
    }

    protected Brain.BrainCodec<PiglinPrisonerEntity> func_230289_cH_() {
        return Brain.func_233705_a_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamic) {
        return PiglinPrisonerAi.makeBrain(this, (Brain<PiglinPrisonerEntity>)this.func_230289_cH_().func_233748_a_(dynamic));
    }

    public Brain<PiglinPrisonerEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    public ActionResultType func_230254_b_(PlayerEntity pPlayer, Hand pHand) {
        ActionResultType actionresulttype = super.func_230254_b_(pPlayer, pHand);
        if (actionresulttype.func_226246_a_()) {
            return actionresulttype;
        }
        if (!this.field_70170_p.field_72995_K) {
            return PiglinPrisonerAi.mobInteract(this, pPlayer, pHand);
        }
        boolean flag = PiglinPrisonerAi.canAdmire(this, pPlayer.func_184586_b(pHand)) && this.func_234424_eM_() != PiglinAction.ADMIRING_ITEM;
        return flag ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    protected float func_213348_b(Pose pPose, EntitySize pSize) {
        return 1.74f;
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() * 0.92;
    }

    public boolean func_70631_g_() {
        return false;
    }

    protected boolean func_234422_eK_() {
        return false;
    }

    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("piglinBrain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, (LivingEntity)this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        PiglinPrisonerAi.updateActivity(this);
        super.func_70619_bc();
    }

    protected int func_70693_a(PlayerEntity pPlayer) {
        return this.field_70728_aV;
    }

    protected void func_234416_a_(ServerWorld pServerLevel) {
        PiglinPrisonerAi.cancelAdmiring(this);
        this.inventory.func_233543_f_().forEach(arg_0 -> ((PiglinPrisonerEntity)this).func_199701_a_(arg_0));
        super.func_234416_a_(pServerLevel);
    }

    private boolean isChargingCrossbow() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_IS_CHARGING_CROSSBOW);
    }

    public void func_213671_a(boolean pIsCharging) {
        this.field_70180_af.func_187227_b(DATA_IS_CHARGING_CROSSBOW, (Object)pIsCharging);
    }

    public void func_230283_U__() {
        this.field_70708_bq = 0;
    }

    public PiglinAction func_234424_eM_() {
        if (this.isDancing()) {
            return PiglinAction.DANCING;
        }
        if (PiglinPrisonerAi.isLovedItem(this.func_184592_cb().func_77973_b())) {
            return PiglinAction.ADMIRING_ITEM;
        }
        if (this.func_213398_dR() && this.func_242338_eO()) {
            return PiglinAction.ATTACKING_WITH_MELEE_WEAPON;
        }
        if (this.isChargingCrossbow()) {
            return PiglinAction.CROSSBOW_CHARGE;
        }
        return this.func_213398_dR() && this.func_233634_a_(item -> item instanceof CrossbowItem) ? PiglinAction.CROSSBOW_HOLD : PiglinAction.DEFAULT;
    }

    public boolean isDancing() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_IS_DANCING);
    }

    public void setDancing(boolean pDancing) {
        this.field_70180_af.func_187227_b(DATA_IS_DANCING, (Object)pDancing);
    }

    public boolean func_70097_a(DamageSource pSource, float pAmount) {
        boolean flag = super.func_70097_a(pSource, pAmount);
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (flag && pSource.func_76346_g() instanceof LivingEntity) {
            PiglinPrisonerAi.wasHurtBy(this, (LivingEntity)pSource.func_76346_g());
        }
        return flag;
    }

    public void func_82196_d(LivingEntity pTarget, float pVelocity) {
        this.func_234281_b_((LivingEntity)this, 1.6f);
    }

    public void func_230284_a_(LivingEntity pTarget, ItemStack pCrossbowStack, ProjectileEntity pProjectile, float pProjectileAngle) {
        this.func_234279_a_((LivingEntity)this, pTarget, pProjectile, pProjectileAngle, 1.6f);
    }

    public boolean func_230280_a_(ShootableItem pProjectileWeapon) {
        return pProjectileWeapon == Items.field_222114_py;
    }

    public void holdInMainHand(ItemStack pStack) {
        this.func_233657_b_(EquipmentSlotType.MAINHAND, pStack);
    }

    public void holdInOffHand(ItemStack pStack) {
        if (pStack.isPiglinCurrency()) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, pStack);
            this.func_233663_d_(EquipmentSlotType.OFFHAND);
        } else {
            this.func_233657_b_(EquipmentSlotType.OFFHAND, pStack);
        }
    }

    public boolean func_230293_i_(ItemStack pStack) {
        return ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) && this.func_98052_bS() && PiglinPrisonerAi.wantsToPickup(this, pStack);
    }

    public boolean canReplaceCurrentItem(ItemStack pCandidate) {
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d((ItemStack)pCandidate);
        ItemStack itemstack = this.func_184582_a(equipmentslottype);
        return this.func_208003_a(pCandidate, itemstack);
    }

    protected boolean func_208003_a(ItemStack pCandidate, ItemStack pExisting) {
        boolean flag1;
        if (EnchantmentHelper.func_190938_b((ItemStack)pExisting)) {
            return false;
        }
        boolean flag = PiglinPrisonerAi.isLovedItem(pCandidate.func_77973_b()) || pCandidate.func_77973_b() == Items.field_222114_py;
        boolean bl = flag1 = PiglinPrisonerAi.isLovedItem(pExisting.func_77973_b()) || pExisting.func_77973_b() == Items.field_222114_py;
        if (flag && !flag1) {
            return true;
        }
        if (!flag && flag1) {
            return false;
        }
        return (!this.func_242337_eM() || pCandidate.func_77973_b() == Items.field_222114_py || pExisting.func_77973_b() != Items.field_222114_py) && super.func_208003_a(pCandidate, pExisting);
    }

    protected void func_175445_a(ItemEntity pItemEntity) {
        this.func_233630_a_(pItemEntity);
        PiglinPrisonerAi.pickUpItem(this, pItemEntity);
    }

    protected SoundEvent func_184639_G() {
        return this.field_70170_p.field_72995_K ? null : (SoundEvent)PiglinPrisonerAi.getSoundForCurrentActivity(this).orElse(null);
    }

    protected SoundEvent func_184601_bQ(DamageSource pDamageSource) {
        return SoundEvents.field_232793_kX_;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_232791_kV_;
    }

    protected void func_180429_a(BlockPos pPos, BlockState pBlock) {
        this.func_184185_a(SoundEvents.field_232795_kZ_, 0.15f, 1.0f);
    }

    public void playSound(SoundEvent pSound) {
        this.func_184185_a(pSound, this.func_70599_aP(), this.func_70647_i());
    }

    protected void func_241848_eP() {
        this.playSound(SoundEvents.field_232799_la_);
    }

    @Nullable
    public PlayerEntity getTempter() {
        try {
            UUID uuid = this.getTempterUUID();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    @Nullable
    public UUID getTempterUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setTempterUUID(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }
}

