/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.izofar.bygonenether.client.model.WarpedEndermanModel;
import com.izofar.bygonenether.client.renderer.layers.ModEndermanEyesLayer;
import com.izofar.bygonenether.entity.WarpedEndermanEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class WarpedEnderManRenderer
extends MobRenderer<WarpedEndermanEntity, WarpedEndermanModel> {
    private static final Map<WarpedEndermanEntity.WarpedEnderManVariant, ResourceLocation> WARPED_ENDERMAN_LOCATION_MAP = ImmutableMap.of((Object)((Object)WarpedEndermanEntity.WarpedEnderManVariant.FRESH), (Object)new ResourceLocation("bygonenether", "textures/entity/warped_enderman/warped_enderman_fresh.png"), (Object)((Object)WarpedEndermanEntity.WarpedEnderManVariant.SHORT_VINE), (Object)new ResourceLocation("bygonenether", "textures/entity/warped_enderman/warped_enderman_short_vine.png"), (Object)((Object)WarpedEndermanEntity.WarpedEnderManVariant.LONG_VINE), (Object)new ResourceLocation("bygonenether", "textures/entity/warped_enderman/warped_enderman_long_vine.png"));
    private final Random random = new Random();

    public WarpedEnderManRenderer(EntityRendererManager manager) {
        super(manager, (EntityModel)new WarpedEndermanModel(0.0f), 0.5f);
        this.func_177094_a((LayerRenderer)new ModEndermanEyesLayer((IEntityRenderer<WarpedEndermanEntity, WarpedEndermanModel>)this));
    }

    public void render(WarpedEndermanEntity pEntity, float pEntityYaw, float pPartialTicks, MatrixStack pMatrixStack, IRenderTypeBuffer pBuffer, int pPackedLight) {
        BlockState blockstate = pEntity.func_195405_dq();
        WarpedEndermanModel endermanmodel = (WarpedEndermanModel)this.func_217764_d();
        endermanmodel.field_78126_a = blockstate != null;
        endermanmodel.field_78125_b = pEntity.func_70823_r();
        super.func_225623_a_((MobEntity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public Vector3d getRenderOffset(WarpedEndermanEntity pEntity, float pPartialTicks) {
        if (pEntity.func_70823_r()) {
            return new Vector3d(this.random.nextGaussian() * 0.02, 0.0, this.random.nextGaussian() * 0.02);
        }
        return super.func_225627_b_((Entity)pEntity, pPartialTicks);
    }

    public ResourceLocation getTextureLocation(WarpedEndermanEntity enderman) {
        return WARPED_ENDERMAN_LOCATION_MAP.get((Object)enderman.getVariant());
    }
}

