/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.buzzier_bees.core;

import com.minecraftabnormals.abnormals_core.core.util.registry.RegistryHelper;
import com.minecraftabnormals.buzzier_bees.core.BBConfig;
import com.minecraftabnormals.buzzier_bees.core.data.server.BBAdvancementProvider;
import com.minecraftabnormals.buzzier_bees.core.data.server.tags.BBBlockTagsProvider;
import com.minecraftabnormals.buzzier_bees.core.data.server.tags.BBEntityTypeTagsProvider;
import com.minecraftabnormals.buzzier_bees.core.data.server.tags.BBItemTagsGenerator;
import com.minecraftabnormals.buzzier_bees.core.other.BBCompat;
import com.minecraftabnormals.buzzier_bees.core.registry.BBEffects;
import com.minecraftabnormals.buzzier_bees.core.registry.BBEntities;
import com.minecraftabnormals.buzzier_bees.core.registry.BBFeatures;
import com.minecraftabnormals.buzzier_bees.core.registry.BBItems;
import com.minecraftabnormals.buzzier_bees.core.registry.BBPaintings;
import com.minecraftabnormals.buzzier_bees.core.registry.BBParticles;
import com.minecraftabnormals.buzzier_bees.core.registry.BBVillagers;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="buzzier_bees")
@Mod.EventBusSubscriber(modid="buzzier_bees")
public class BuzzierBees {
    public static final String MOD_ID = "buzzier_bees";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("buzzier_bees");

    public BuzzierBees() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        REGISTRY_HELPER.register(modEventBus);
        BBPaintings.PAINTINGS.register(modEventBus);
        BBParticles.PARTICLES.register(modEventBus);
        BBEffects.POTIONS.register(modEventBus);
        BBEffects.EFFECTS.register(modEventBus);
        BBVillagers.PROFESSIONS.register(modEventBus);
        BBVillagers.POI_TYPES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::dataSetup);
        context.registerConfig(ModConfig.Type.COMMON, BBConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BBCompat.registerCompat();
            BBEffects.registerRecipes();
            BBEntities.registerEntitySpawns();
            BBVillagers.registerVillagers();
            BBFeatures.Configured.registerConfiguredFeatures();
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
        BBEntities.registerRenderers();
        event.enqueueWork(() -> {
            BBCompat.registerRenderLayers();
            BBItems.registerItemProperties();
        });
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            BBBlockTagsProvider blockTagGen = new BBBlockTagsProvider(dataGenerator, existingFileHelper);
            dataGenerator.func_200390_a((IDataProvider)blockTagGen);
            dataGenerator.func_200390_a((IDataProvider)new BBItemTagsGenerator(dataGenerator, blockTagGen, existingFileHelper));
            dataGenerator.func_200390_a((IDataProvider)new BBEntityTypeTagsProvider(dataGenerator, existingFileHelper));
            dataGenerator.func_200390_a((IDataProvider)new BBAdvancementProvider(dataGenerator));
        }
    }
}

