/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.cave;

import com.legacy.blue_skies.blocks.natural.SkyDripstoneBlock;
import com.legacy.blue_skies.blocks.util.IFluidLoggable;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.general_features.cave.AbstractCaveFeature;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.common.Tags;

public class SkyDripstoneFeature
extends AbstractCaveFeature<Config> {
    public SkyDripstoneFeature(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public boolean generate(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, Config config) {
        int spread = 15;
        int half = spread / 2;
        for (int i = 0; i < 30; ++i) {
            this.createDripstone(world, chunkGen, rand, pos.func_177982_a(rand.nextInt(spread) - spread, rand.nextInt(spread) - half, rand.nextInt(spread) - half), config, SkyDripstoneBlock.Type.STALAGMITE);
            this.createDripstone(world, chunkGen, rand, pos.func_177982_a(rand.nextInt(spread) - spread, rand.nextInt(spread) - half, rand.nextInt(spread) - half), config, SkyDripstoneBlock.Type.STALACTITE);
        }
        return true;
    }

    private void createDripstone(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, Config config, SkyDripstoneBlock.Type type) {
        BlockState state = (BlockState)config.dripstone.func_176223_P().func_206870_a(SkyDripstoneBlock.TYPE, (Comparable)((Object)type));
        BlockState placeOnto = world.func_180495_p(pos.func_177972_a(type.growthDir.func_176734_d()));
        if (this.canReplace(world.func_180495_p(pos)) && placeOnto.func_235714_a_((ITag)Tags.Blocks.STONE)) {
            int y;
            int height = rand.nextInt(config.maxLength);
            for (y = 0; y <= height; ++y) {
                if (this.canReplace(world.func_180495_p(pos.func_177967_a(type.growthDir, y)))) continue;
                height = y - 1;
                break;
            }
            if (height < 0) {
                return;
            }
            for (y = 0; y <= height; ++y) {
                SkyDripstoneBlock.Section section = SkyDripstoneBlock.Section.MIDDLE;
                if (y == 0 && height > 1) {
                    section = SkyDripstoneBlock.Section.BASE;
                } else if (y == height) {
                    section = SkyDripstoneBlock.Section.TIP;
                }
                BlockPos placePos = pos.func_177967_a(type.growthDir, y);
                this.func_230367_a_((IWorldWriter)world, placePos, (BlockState)((BlockState)state.func_206870_a(SkyDripstoneBlock.SECTION, (Comparable)((Object)section))).func_206870_a(IFluidLoggable.FLUIDLOGGED, (Comparable)((Object)IFluidLoggable.FluidLogging.from(world.func_204610_c(placePos).func_206886_c()))));
            }
        }
    }

    private boolean canReplace(BlockState state) {
        return state.func_185904_a() == Material.field_151579_a || state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150353_l;
    }

    @Override
    public int getMaxHeight(Config config) {
        return 10;
    }

    @Override
    public boolean isValidPos(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, Config config) {
        return true;
    }

    public static class Config
    implements IFeatureConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212618_g.fieldOf("dripstone").forGetter(config -> config.dripstone), (App)Codec.INT.fieldOf("maxLength").forGetter(config -> config.maxLength)).apply((Applicative)instance, Config::new));
        public final SkyDripstoneBlock dripstone;
        public final int maxLength;

        public Config(Block dripstone, int maxLength) {
            this.dripstone = dripstone instanceof SkyDripstoneBlock ? (SkyDripstoneBlock)dripstone : SkiesBlocks.lunar_dripstone;
            this.maxLength = maxLength;
        }
    }
}

