/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.cave;

import com.legacy.blue_skies.registries.SkiesFeatures;
import com.legacy.blue_skies.util.GeometryHelper;
import com.legacy.blue_skies.world.general_features.cave.AbstractCaveFeature;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class CaveGrassFeature
extends AbstractCaveFeature<Config> {
    public CaveGrassFeature(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public boolean generate(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, Config config) {
        int width = rand.nextInt(6) + 5;
        int height = rand.nextInt(6) + 5;
        int depth = rand.nextInt(6) + 5;
        float grassChance = rand.nextFloat() * 0.25f;
        for (int x = -width; x <= width; ++x) {
            for (int z = -depth; z <= depth; ++z) {
                for (int y = -height; y <= height; ++y) {
                    BlockPos offsetPos;
                    BlockState state;
                    if (!GeometryHelper.isInEllipsoid(width, height, depth, x, y, z) || !SkiesFeatures.Carvers.CARVABLE_BLOCKS.contains((state = world.func_180495_p(offsetPos = pos.func_177982_a(x, y, z))).func_177230_c()) || state.func_185904_a() == Material.field_151588_w || state.func_185904_a() == Material.field_151598_x || !world.func_175623_d(offsetPos.func_177984_a())) continue;
                    this.func_230367_a_((IWorldWriter)world, offsetPos, config.grass_block);
                    if (rand.nextFloat() < grassChance) {
                        this.func_230367_a_((IWorldWriter)world, offsetPos.func_177984_a(), config.grass);
                    }
                    if (!rand.nextBoolean() || offsetPos.func_177979_c(1).func_177956_o() <= 2) continue;
                    this.func_230367_a_((IWorldWriter)world, offsetPos.func_177979_c(1), config.dirt);
                    if (!rand.nextBoolean() || offsetPos.func_177979_c(2).func_177956_o() <= 2) continue;
                    this.func_230367_a_((IWorldWriter)world, offsetPos.func_177979_c(2), config.dirt);
                }
            }
        }
        return true;
    }

    @Override
    public boolean isValidPos(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, Config config) {
        return true;
    }

    public static class Config
    implements IFeatureConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.field_235877_b_.fieldOf("grass_block").forGetter(config -> config.grass_block), (App)BlockState.field_235877_b_.fieldOf("dirt").forGetter(config -> config.dirt), (App)BlockState.field_235877_b_.fieldOf("grass").forGetter(config -> config.grass)).apply((Applicative)instance, Config::new));
        public final BlockState grass_block;
        public final BlockState dirt;
        public final BlockState grass;

        public Config(BlockState grass_block, BlockState dirt, BlockState grass) {
            this.grass_block = grass_block;
            this.dirt = dirt;
            this.grass = grass;
        }
    }
}

