/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.common.Tags;

public class BushFeature
extends Feature<Config> {
    public BushFeature(Codec<Config> config) {
        super(config);
    }

    public boolean place(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, Config config) {
        boolean insideDungeon = worldIn.func_241827_a(SectionPos.func_218167_a((BlockPos)pos), SkiesStructures.NATURE_DUNGEON.getStructure()).findAny().isPresent();
        if (config.fromDungeon && !insideDungeon || !config.fromDungeon && insideDungeon) {
            return false;
        }
        if (config.fromDungeon && worldIn.func_217375_a(pos.func_177977_b(), state -> state.func_177230_c() != SkiesBlocks.turquoise_grass_block)) {
            return false;
        }
        if (worldIn.func_217375_a(pos.func_177977_b(), state -> Tags.Blocks.DIRT.func_230235_a_((Object)state.func_177230_c()))) {
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    for (int y = 0; y < 2; ++y) {
                        if (y == 1 && Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                        worldIn.func_180501_a(pos.func_177982_a(x, y, z), (BlockState)config.leaf.func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)), 3);
                    }
                }
            }
            worldIn.func_180501_a(pos, config.log, 3);
        }
        return false;
    }

    protected void setBlock(IWorldGenerationReader worldIn, BlockPos pos, BlockState state) {
        if (this.canReplace(worldIn, pos)) {
            worldIn.func_180501_a(pos, state, 2);
        }
    }

    private boolean canReplace(IWorldGenerationReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, blockState -> BlockTags.field_206952_E.func_230235_a_((Object)blockState.func_177230_c()) || BlockTags.field_200031_h.func_230235_a_((Object)blockState.func_177230_c()) || blockState.func_177230_c() == Blocks.field_150433_aE);
    }

    public static class Config
    implements IFeatureConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.field_235877_b_.fieldOf("log").forGetter(config -> config.log), (App)BlockState.field_235877_b_.fieldOf("leaf").forGetter(config -> config.leaf), (App)Codec.BOOL.fieldOf("fromDungeon").forGetter(config -> config.fromDungeon)).apply((Applicative)instance, Config::new));
        public final BlockState log;
        public final BlockState leaf;
        public final boolean fromDungeon;

        public Config(BlockState log, BlockState leaf, boolean fromDungeon) {
            this.log = log;
            this.leaf = leaf;
            this.fromDungeon = fromDungeon;
        }
    }
}

